/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.chunk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.semanticweb.binaryowl.BinaryOWLMetadata;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.chunk.ChunkUtil;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;

public class BinaryOWLMetadataChunk {
    public static final int CHUNK_TYPE = ChunkUtil.toInt("bomd");
    private BinaryOWLMetadata metadata;

    public BinaryOWLMetadataChunk(BinaryOWLMetadata metadata) {
        this.metadata = metadata;
    }

    public BinaryOWLMetadataChunk(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        inputStream.skipBytes(8);
        this.metadata = new BinaryOWLMetadata(inputStream);
    }

    public BinaryOWLMetadata getMetadata() {
        return this.metadata;
    }

    public void write(BinaryOWLOutputStream outputStream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.metadata.write(new BinaryOWLOutputStream(buffer, outputStream.getVersion()));
        outputStream.writeInt(buffer.size());
        outputStream.writeInt(CHUNK_TYPE);
        buffer.writeTo(outputStream);
    }
}

