/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.change;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.change.OntologyChangeDataType;
import org.semanticweb.binaryowl.owlobject.serializer.BinaryOWLOntologyID;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyChangeRecordRun {
    private OWLOntologyID ontologyID;
    private List<OWLOntologyChangeData> records;

    public OntologyChangeRecordRun(OWLOntologyID ontologyID, List<OWLOntologyChangeData> records) {
        this.ontologyID = ontologyID;
        this.records = new ArrayList<OWLOntologyChangeData>(records);
    }

    public OntologyChangeRecordRun(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        this.read(inputStream);
    }

    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    public List<OWLOntologyChangeData> getChangeDataList() {
        return new ArrayList<OWLOntologyChangeData>(this.records);
    }

    public void write(BinaryOWLOutputStream outputStream) throws IOException {
        BinaryOWLOntologyID serializer = new BinaryOWLOntologyID(this.ontologyID);
        serializer.write(outputStream);
        outputStream.writeInt(this.records.size());
        for (OWLOntologyChangeData info : this.records) {
            OntologyChangeDataType.write(info, outputStream);
        }
    }

    private void read(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        BinaryOWLOntologyID idSerializer = new BinaryOWLOntologyID(inputStream);
        this.ontologyID = idSerializer.getOntologyID();
        int recordCount = inputStream.readInt();
        this.records = new ArrayList<OWLOntologyChangeData>(recordCount + 1);
        for (int i = 0; i < recordCount; ++i) {
            OWLOntologyChangeData info = OntologyChangeDataType.read(inputStream);
            this.records.add(info);
        }
    }
}

