/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.awt.Color;
import java.util.Date;
import java.util.Map;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Group;
import net.sf.mpxj.GroupClause;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.mpp.BackgroundPattern;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.FontStyle;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.utility.FieldTypeUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupReader14 {
    private static final Integer GROUP_DATA = 6;

    public void process(ProjectFile file, FixedData fixedData, Var2Data varData, Map<Integer, FontBase> fontBases) {
        int groupCount = fixedData.getItemCount();
        for (int groupLoop = 0; groupLoop < groupCount; ++groupLoop) {
            Integer groupID;
            byte[] groupVarData;
            byte[] groupFixedData = fixedData.getByteArrayValue(groupLoop);
            if (groupFixedData == null || groupFixedData.length < 4 || (groupVarData = varData.getByteArray(groupID = Integer.valueOf(MPPUtility.getInt(groupFixedData, 0)), GROUP_DATA)) == null) continue;
            String groupName = MPPUtility.getUnicodeString(groupFixedData, 4);
            boolean showSummaryTasks = MPPUtility.getShort(groupVarData, 4) != 0;
            Group group = new Group(groupID, groupName, showSummaryTasks);
            file.addGroup(group);
            int clauseCount = MPPUtility.getShort(groupVarData, 10);
            int offset = 12;
            for (int clauseIndex = 0; clauseIndex < clauseCount && offset + 71 <= groupVarData.length; ++clauseIndex) {
                GroupClause clause = new GroupClause();
                group.addGroupClause(clause);
                int fieldID = MPPUtility.getInt(groupVarData, offset);
                FieldType type = FieldTypeUtility.getInstance14(fieldID);
                clause.setField(type);
                boolean ascending = MPPUtility.getByte(groupVarData, offset + 4) != 0;
                clause.setAscending(ascending);
                int fontIndex = MPPUtility.getByte(groupVarData, offset + 8);
                FontBase fontBase = fontBases.get(fontIndex);
                int style = MPPUtility.getByte(groupVarData, offset + 9);
                boolean bold = (style & 1) != 0;
                boolean italic = (style & 2) != 0;
                boolean underline = (style & 4) != 0;
                Color fontColor = MPPUtility.getColor(groupVarData, offset + 10);
                FontStyle fontStyle = new FontStyle(fontBase, italic, bold, underline, false, fontColor, null, BackgroundPattern.SOLID);
                clause.setFont(fontStyle);
                clause.setCellBackgroundColor(MPPUtility.getColor(groupVarData, offset + 22));
                clause.setPattern(BackgroundPattern.getInstance(MPPUtility.getByte(groupVarData, offset + 34) & 0xF));
                int groupOn = MPPUtility.getByte(groupVarData, offset + 38);
                clause.setGroupOn(groupOn);
                Comparable<Date> startAt = null;
                Number groupInterval = null;
                if (type != null) {
                    switch (type.getDataType()) {
                        case DURATION: 
                        case NUMERIC: 
                        case CURRENCY: {
                            startAt = MPPUtility.getDouble(groupVarData, offset + 47);
                            groupInterval = MPPUtility.getDouble(groupVarData, offset + 63);
                            break;
                        }
                        case PERCENTAGE: {
                            startAt = MPPUtility.getInt(groupVarData, offset + 47);
                            groupInterval = MPPUtility.getInt(groupVarData, offset + 63);
                            break;
                        }
                        case BOOLEAN: {
                            startAt = MPPUtility.getShort(groupVarData, offset + 47) == 1 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case DATE: {
                            startAt = MPPUtility.getTimestamp(groupVarData, offset + 47);
                            groupInterval = MPPUtility.getInt(groupVarData, offset + 63);
                            break;
                        }
                    }
                }
                clause.setStartAt(startAt);
                clause.setGroupInterval(groupInterval);
                offset += 71;
            }
        }
    }
}

