/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mailprobe.smtp;

import java.util.Hashtable;
import java.util.TreeMap;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class MXLookup {
    public TreeMap<Integer, String> getMXHosts(String mailDomainName) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext dirContext = new InitialDirContext(env);
        Attributes attrs = dirContext.getAttributes(mailDomainName, new String[]{"MX"});
        Attribute attr = attrs.get("MX");
        if ((attr == null || attr.size() == 0) && (attr = (attrs = dirContext.getAttributes(mailDomainName, new String[]{"A"})).get("A")) == null) {
            throw new NamingException("No finding for name '" + mailDomainName + "'");
        }
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        NamingEnumeration<?> namingEnumeration = attr.getAll();
        while (namingEnumeration.hasMore()) {
            String mailhost;
            Integer priority = new Integer(0);
            String x = (String)namingEnumeration.next();
            String[] f = x.split(" ");
            if (f.length == 1) {
                mailhost = f[0];
                priority = new Integer(0);
            } else if (f[1].endsWith(".")) {
                mailhost = f[1].substring(0, f[1].length() - 1);
                priority = new Integer(f[0]);
            } else {
                mailhost = f[1];
                priority = new Integer(0);
            }
            result.put(priority, mailhost);
        }
        if (result.size() == 0) {
            throw new NamingException("No finding for name '" + mailDomainName + "'");
        }
        return result;
    }
}

