/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mailprobe.check;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import net.sourceforge.mailprobe.smtp.MXLookup;
import net.sourceforge.mailprobe.util.ExecStats;

public class SMTPServerCheck {
    private static final Logger logger = Logger.getLogger(SMTPServerCheck.class.getName());

    private int hear(BufferedReader in) throws IOException {
        String line = null;
        int res = 0;
        while ((line = in.readLine()) != null) {
            String pfx = line.substring(0, 3);
            try {
                res = Integer.parseInt(pfx);
            }
            catch (Exception ex) {
                res = -1;
            }
            if (line.charAt(3) == '-') continue;
            break;
        }
        return res;
    }

    private void say(BufferedWriter wr, String text) throws IOException {
        wr.write(text + "\r\n");
        wr.flush();
    }

    public ExecStats simpleMXPing(String mailDomainName, String localhostName) {
        TreeMap<Integer, String> mxList = null;
        ExecStats result = new ExecStats(new Date());
        try {
            mxList = new MXLookup().getMXHosts(mailDomainName);
            for (Map.Entry<Integer, String> entry : mxList.entrySet()) {
                if (!this.simplePing(mxList.get(entry.getKey()), localhostName).isSuccess()) continue;
                result.setSuccess(true);
                break;
            }
        }
        catch (NamingException ex) {
            logger.log(Level.FINE, "mailDomainHost not found via DNS.", ex);
        }
        result.setEndDate(new Date());
        return result;
    }

    public ExecStats simplePing(String exchangerHostName, String localhostName) {
        ExecStats result = new ExecStats(new Date());
        try {
            if (localhostName == null) {
                localhostName = InetAddress.getLocalHost().getHostName();
            }
            Socket socket = new Socket(exchangerHostName, 25);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            int res = this.hear(bufferedReader);
            if (res != 220) {
                throw new Exception("Invalid header of SMTP server.");
            }
            this.say(bufferedWriter, "EHLO " + localhostName);
            res = this.hear(bufferedReader);
            if (res != 250) {
                throw new Exception("Not ESMTP");
            }
            this.say(bufferedWriter, "NOOP");
            res = this.hear(bufferedReader);
            if (res != 250) {
                throw new Exception("NOOP is not supported");
            }
            this.say(bufferedWriter, "QUIT");
            res = this.hear(bufferedReader);
            if (res != 221) {
                throw new Exception("QUIT doesn't work as expected");
            }
            result.setSuccess(true);
            bufferedReader.close();
            bufferedWriter.close();
            socket.close();
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Error while testing certain mail hosts: " + exchangerHostName, ex);
        }
        result.setEndDate(new Date());
        return result;
    }
}

