/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xerces.util;

import java.util.ArrayList;
import net.sourceforge.htmlunit.xerces.util.AugmentationsImpl;
import net.sourceforge.htmlunit.xerces.xni.Augmentations;
import net.sourceforge.htmlunit.xerces.xni.QName;
import net.sourceforge.htmlunit.xerces.xni.XMLAttributes;

public class XMLAttributesImpl
implements XMLAttributes {
    private ArrayList<Attribute> fAttributes = new ArrayList();

    @Override
    public int addAttribute(QName name, String type, String value) {
        Attribute attribute = new Attribute();
        attribute.name.setValues(name);
        attribute.type = type;
        attribute.value = value;
        attribute.nonNormalizedValue = value;
        attribute.specified = false;
        attribute.augs.clear();
        this.fAttributes.add(attribute);
        return this.fAttributes.size() - 1;
    }

    @Override
    public void removeAllAttributes() {
        this.fAttributes.clear();
    }

    @Override
    public void removeAttributeAt(int attrIndex) {
        this.fAttributes.remove(attrIndex);
    }

    @Override
    public void setName(int attrIndex, QName attrName) {
        this.fAttributes.get((int)attrIndex).name.setValues(attrName);
    }

    @Override
    public void getName(int attrIndex, QName attrName) {
        attrName.setValues(this.fAttributes.get((int)attrIndex).name);
    }

    @Override
    public void setType(int attrIndex, String attrType) {
        this.fAttributes.get((int)attrIndex).type = attrType;
    }

    @Override
    public void setValue(int attrIndex, String attrValue) {
        Attribute attribute = this.fAttributes.get(attrIndex);
        attribute.value = attrValue;
        attribute.nonNormalizedValue = attrValue;
    }

    @Override
    public void setNonNormalizedValue(int attrIndex, String attrValue) {
        if (attrValue == null) {
            attrValue = this.fAttributes.get((int)attrIndex).value;
        }
        this.fAttributes.get((int)attrIndex).nonNormalizedValue = attrValue;
    }

    @Override
    public String getNonNormalizedValue(int attrIndex) {
        return this.fAttributes.get((int)attrIndex).nonNormalizedValue;
    }

    @Override
    public void setSpecified(int attrIndex, boolean specified) {
        this.fAttributes.get((int)attrIndex).specified = specified;
    }

    @Override
    public boolean isSpecified(int attrIndex) {
        return this.fAttributes.get((int)attrIndex).specified;
    }

    @Override
    public int getLength() {
        return this.fAttributes.size();
    }

    @Override
    public String getType(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.getReportableType(this.fAttributes.get((int)index).type);
    }

    @Override
    public String getType(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? this.getReportableType(this.fAttributes.get((int)index).type) : null;
    }

    @Override
    public String getValue(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.fAttributes.get((int)index).value;
    }

    @Override
    public String getValue(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? this.fAttributes.get((int)index).value : null;
    }

    public String getName(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.fAttributes.get((int)index).name.rawname;
    }

    @Override
    public int getIndex(String qName) {
        for (int i = 0; i < this.getLength(); ++i) {
            Attribute attribute = this.fAttributes.get(i);
            if (attribute.name.rawname == null || !attribute.name.rawname.equals(qName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String uri, String localPart) {
        for (int i = 0; i < this.getLength(); ++i) {
            Attribute attribute = this.fAttributes.get(i);
            if (attribute.name.localpart == null || !attribute.name.localpart.equals(localPart) || uri != attribute.name.uri && (uri == null || attribute.name.uri == null || !attribute.name.uri.equals(uri))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getLocalName(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.fAttributes.get((int)index).name.localpart;
    }

    @Override
    public String getQName(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        String rawname = this.fAttributes.get((int)index).name.rawname;
        return rawname != null ? rawname : "";
    }

    @Override
    public String getType(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getReportableType(this.fAttributes.get((int)index).type) : null;
    }

    @Override
    public String getURI(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.fAttributes.get((int)index).name.uri;
    }

    @Override
    public String getValue(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getValue(index) : null;
    }

    @Override
    public Augmentations getAugmentations(int attributeIndex) {
        if (attributeIndex < 0 || attributeIndex >= this.getLength()) {
            return null;
        }
        return this.fAttributes.get((int)attributeIndex).augs;
    }

    public void addAttributeNS(QName name, String type, String value) {
        Attribute attribute = new Attribute();
        attribute.name.setValues(name);
        attribute.type = type;
        attribute.value = value;
        attribute.nonNormalizedValue = value;
        attribute.specified = false;
        attribute.augs.clear();
        this.fAttributes.add(attribute);
    }

    private String getReportableType(String type) {
        if (type.charAt(0) == '(') {
            return "NMTOKEN";
        }
        return type;
    }

    static final class Attribute {
        public final QName name = new QName();
        public String type;
        public String value;
        public String nonNormalizedValue;
        public boolean specified;
        public final Augmentations augs = new AugmentationsImpl();

        Attribute() {
        }
    }
}

