/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xerces.util;

import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.htmlunit.xerces.xni.parser.XMLComponentManager;
import net.sourceforge.htmlunit.xerces.xni.parser.XMLConfigurationException;

public class ParserConfigurationSettings
implements XMLComponentManager {
    protected final ArrayList<String> fRecognizedProperties;
    protected final HashMap<String, Object> fProperties;
    protected final ArrayList<String> fRecognizedFeatures = new ArrayList();
    protected final HashMap<String, Boolean> fFeatures;

    public ParserConfigurationSettings() {
        this.fRecognizedProperties = new ArrayList();
        this.fFeatures = new HashMap();
        this.fProperties = new HashMap();
    }

    public void addRecognizedFeatures(String[] featureIds) {
        int featureIdsCount = featureIds != null ? featureIds.length : 0;
        for (int i = 0; i < featureIdsCount; ++i) {
            String featureId = featureIds[i];
            if (this.fRecognizedFeatures.contains(featureId)) continue;
            this.fRecognizedFeatures.add(featureId);
        }
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        this.checkFeature(featureId);
        this.fFeatures.put(featureId, state ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addRecognizedProperties(String[] propertyIds) {
        int propertyIdsCount = propertyIds != null ? propertyIds.length : 0;
        for (int i = 0; i < propertyIdsCount; ++i) {
            String propertyId = propertyIds[i];
            if (this.fRecognizedProperties.contains(propertyId)) continue;
            this.fRecognizedProperties.add(propertyId);
        }
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        this.checkProperty(propertyId);
        this.fProperties.put(propertyId, value);
    }

    @Override
    public boolean getFeature(String featureId) throws XMLConfigurationException {
        Boolean state = this.fFeatures.get(featureId);
        if (state == null) {
            this.checkFeature(featureId);
            return false;
        }
        return state;
    }

    @Override
    public Object getProperty(String propertyId) throws XMLConfigurationException {
        Object propertyValue = this.fProperties.get(propertyId);
        if (propertyValue == null) {
            this.checkProperty(propertyId);
        }
        return propertyValue;
    }

    protected void checkFeature(String featureId) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(featureId)) {
            short type = 0;
            throw new XMLConfigurationException(type, featureId);
        }
    }

    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(propertyId)) {
            short type = 0;
            throw new XMLConfigurationException(type, propertyId);
        }
    }
}

