/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSRuleListImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.dom.MediaListImpl;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.util.LangUtils;
import com.gargoylesoftware.css.util.ThrowCssExceptionErrorHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public class CSSMediaRuleImpl
extends AbstractCSSRuleImpl {
    private MediaListImpl mediaList_;
    private CSSRuleListImpl cssRules_;

    public CSSMediaRuleImpl(CSSStyleSheetImpl parentStyleSheet, AbstractCSSRuleImpl parentRule, MediaListImpl media) {
        super(parentStyleSheet, parentRule);
        this.mediaList_ = media;
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder("@media ");
        sb.append(this.getMediaList().getMediaText());
        sb.append(" {");
        for (int i = 0; i < this.getCssRules().getLength(); ++i) {
            AbstractCSSRuleImpl rule = this.getCssRules().getRules().get(i);
            sb.append(rule.getCssText()).append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        block16: {
            try (InputSource is = new InputSource(new StringReader(cssText));){
                CSSOMParser parser = new CSSOMParser();
                AbstractCSSRuleImpl r = parser.parseRule(is);
                if (r instanceof CSSMediaRuleImpl) {
                    this.mediaList_ = ((CSSMediaRuleImpl)r).mediaList_;
                    this.cssRules_ = ((CSSMediaRuleImpl)r).cssRules_;
                    break block16;
                }
                throw new DOMExceptionImpl(13, 6);
            }
            catch (CSSException e) {
                throw new DOMExceptionImpl(12, 0, e.getMessage());
            }
            catch (IOException e) {
                throw new DOMExceptionImpl(12, 0, e.getMessage());
            }
        }
    }

    public MediaListImpl getMediaList() {
        return this.mediaList_;
    }

    public CSSRuleListImpl getCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleListImpl();
        }
        return this.cssRules_;
    }

    public void insertRule(String rule, int index) throws DOMException {
        CSSStyleSheetImpl parentStyleSheet = this.getParentStyleSheet();
        try (InputSource is = new InputSource(new StringReader(rule));){
            CSSOMParser parser = new CSSOMParser();
            parser.setParentStyleSheet(parentStyleSheet);
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            AbstractCSSRuleImpl r = parser.parseRule(is);
            this.getCssRules().insert(r, index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public void deleteRule(int index) throws DOMException {
        try {
            this.getCssRules().delete(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
    }

    public void setRuleList(CSSRuleListImpl rules) {
        this.cssRules_ = rules;
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSMediaRuleImpl)) {
            return false;
        }
        CSSMediaRuleImpl cmr = (CSSMediaRuleImpl)obj;
        return super.equals(obj) && LangUtils.equals(this.getMediaList(), cmr.getMediaList()) && LangUtils.equals(this.getCssRules(), cmr.getCssRules());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.mediaList_);
        hash = LangUtils.hashCode(hash, this.cssRules_);
        return hash;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.cssRules_);
        out.writeObject(this.mediaList_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.cssRules_ = (CSSRuleListImpl)in.readObject();
        if (this.cssRules_ != null) {
            for (int i = 0; i < this.cssRules_.getLength(); ++i) {
                AbstractCSSRuleImpl cssRule = this.cssRules_.getRules().get(i);
                cssRule.setParentRule(this);
                cssRule.setParentStyleSheet(this.getParentStyleSheet());
            }
        }
        this.mediaList_ = (MediaListImpl)in.readObject();
    }
}

