/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryOOB;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.UUIDUtils;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ResourceBundleManager;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.util.SFTimestamp;
import net.snowflake.client.util.SecretDetector;

public class TelemetryEvent
extends JSONObject {
    private static final long serialVersionUID = 1L;
    private static final int schemaVersion = 1;

    public String getDeployment() {
        JSONArray tags = (JSONArray)this.get("Tags");
        for (Object tag : tags) {
            JSONObject json = (JSONObject)tag;
            if (json.get((Object)"Name").toString().compareTo("deployment") != 0) continue;
            return json.get((Object)"Value").toString();
        }
        return "Unknown";
    }

    private static class Builder<T> {
        protected final Class<T> builderClass;
        protected TelemetryEvent body = new TelemetryEvent();
        protected HashMap<String, String> tags = new HashMap();
        private static final String version = ResourceBundleManager.getSingleton("net.snowflake.client.jdbc.version").getLocalizedMessage("version");
        private static final String driver = "JDBC";

        public Builder(Class<T> builderClass) {
            this.builderClass = builderClass;
            this.withTag("driver", driver);
            this.withTag("version", version);
            TelemetryService instance = TelemetryService.getInstance();
            this.withTag("telemetryServerDeployment", instance.getServerDeploymentName());
            this.withTag("connectionString", instance.getDriverConnectionString());
            JSONObject context = instance.getContext();
            if (context != null) {
                for (String key : context.keySet()) {
                    Object val = context.get((Object)key);
                    if (val == null) continue;
                    this.withTag("ctx_" + key.toLowerCase(), SecretDetector.maskParameterValue(key, val.toString()));
                }
            }
        }

        public T withName(String name) {
            this.body.put("Name", SecretDetector.maskSecrets(name));
            return this.builderClass.cast(this);
        }

        public T withTag(String name, int value) {
            return this.withTag(name, Integer.toString(value));
        }

        public T withTag(String name, String value) {
            if (value != null && value.length() > 0) {
                this.tags.put(name, SecretDetector.maskSecrets(value));
            }
            return this.builderClass.cast(this);
        }

        protected TelemetryEvent build() {
            this.body.put("UUID", UUIDUtils.getUUID().toString());
            this.body.put("Created_On", SFTimestamp.getUTCNow());
            this.body.put("SchemaVersion", 1);
            this.putMap("Tags", this.tags);
            return this.body;
        }

        private void putMap(String name, HashMap<String, String> map) {
            JSONObject tags = new JSONObject();
            for (String key : map.keySet()) {
                tags.put((Object)key, (Object)map.get(key));
            }
            this.body.put(name, tags);
        }
    }

    public static class LogBuilder
    extends Builder<LogBuilder> {
        public LogBuilder() {
            super(LogBuilder.class);
        }

        public LogBuilder withException(Exception ex) {
            this.withName("Exception:" + ex.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            String stackTrace = sw.toString();
            this.withValue(stackTrace);
            return this;
        }

        public LogBuilder withException(SFException ex) {
            this.withName("Exception:" + ex.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            String stackTrace = sw.toString();
            this.withValue(stackTrace);
            return this;
        }

        public LogBuilder withValue(String value) {
            this.body.put("Value", SecretDetector.maskSecrets(value));
            return this;
        }

        public LogBuilder withValue(JSONObject value) {
            this.body.put("Value", SecretDetector.maskJsonObject(value));
            return this;
        }

        public LogBuilder withValue(JSONArray value) {
            this.body.put("Value", SecretDetector.maskJsonArray(value));
            return this;
        }

        @Override
        public TelemetryEvent build() {
            TelemetryEvent event = super.build();
            event.put("Type", (Object)Type.Log);
            return event;
        }
    }

    public static class MetricBuilder
    extends Builder<MetricBuilder> {
        public MetricBuilder withException(Exception ex) {
            this.withName("Exception:" + ex.getMessage());
            this.withValue(1);
            return this;
        }

        public MetricBuilder() {
            super(MetricBuilder.class);
        }

        public MetricBuilder withValue(int value) {
            this.body.put("Value", value);
            return this;
        }

        public MetricBuilder withValue(float value) {
            this.body.put("Value", Float.valueOf(value));
            return this;
        }

        @Override
        public TelemetryEvent build() {
            TelemetryEvent event = super.build();
            event.put("Type", (Object)Type.Metric);
            return event;
        }
    }

    public static enum Type {
        Metric,
        Log;

    }
}

