/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DecimalVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalYearVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.SmallIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeMicroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeSecVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMicroTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMicroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMilliTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampNanoTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampSecTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampSecVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TinyIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt1Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt2Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarCharVector;

public class GenerateSampleData {
    private GenerateSampleData() {
    }

    public static void generateTestData(ValueVector vector, int valueCount) {
        if (vector instanceof IntVector) {
            GenerateSampleData.writeIntData((IntVector)vector, valueCount);
        } else if (vector instanceof DecimalVector) {
            GenerateSampleData.writeDecimalData((DecimalVector)vector, valueCount);
        } else if (vector instanceof BitVector) {
            GenerateSampleData.writeBooleanData((BitVector)vector, valueCount);
        } else if (vector instanceof VarCharVector) {
            GenerateSampleData.writeVarCharData((VarCharVector)vector, valueCount);
        } else if (vector instanceof VarBinaryVector) {
            GenerateSampleData.writeVarBinaryData((VarBinaryVector)vector, valueCount);
        } else if (vector instanceof BigIntVector) {
            GenerateSampleData.writeBigIntData((BigIntVector)vector, valueCount);
        } else if (vector instanceof Float4Vector) {
            GenerateSampleData.writeFloatData((Float4Vector)vector, valueCount);
        } else if (vector instanceof Float8Vector) {
            GenerateSampleData.writeDoubleData((Float8Vector)vector, valueCount);
        } else if (vector instanceof DateDayVector) {
            GenerateSampleData.writeDateDayData((DateDayVector)vector, valueCount);
        } else if (vector instanceof DateMilliVector) {
            GenerateSampleData.writeDateMilliData((DateMilliVector)vector, valueCount);
        } else if (vector instanceof IntervalDayVector) {
            GenerateSampleData.writeIntervalDayData((IntervalDayVector)vector, valueCount);
        } else if (vector instanceof IntervalYearVector) {
            GenerateSampleData.writeIntervalYearData((IntervalYearVector)vector, valueCount);
        } else if (vector instanceof SmallIntVector) {
            GenerateSampleData.writeSmallIntData((SmallIntVector)vector, valueCount);
        } else if (vector instanceof TinyIntVector) {
            GenerateSampleData.writeTinyIntData((TinyIntVector)vector, valueCount);
        } else if (vector instanceof TimeMicroVector) {
            GenerateSampleData.writeTimeMicroData((TimeMicroVector)vector, valueCount);
        } else if (vector instanceof TimeMilliVector) {
            GenerateSampleData.writeTimeMilliData((TimeMilliVector)vector, valueCount);
        } else if (vector instanceof TimeNanoVector) {
            GenerateSampleData.writeTimeNanoData((TimeNanoVector)vector, valueCount);
        } else if (vector instanceof TimeSecVector) {
            GenerateSampleData.writeTimeSecData((TimeSecVector)vector, valueCount);
        } else if (vector instanceof TimeStampSecVector) {
            GenerateSampleData.writeTimeStampData((TimeStampSecVector)vector, valueCount);
        } else if (vector instanceof TimeStampMicroVector) {
            GenerateSampleData.writeTimeStampData((TimeStampMicroVector)vector, valueCount);
        } else if (vector instanceof TimeStampMilliVector) {
            GenerateSampleData.writeTimeStampData((TimeStampMilliVector)vector, valueCount);
        } else if (vector instanceof TimeStampNanoVector) {
            GenerateSampleData.writeTimeStampData((TimeStampNanoVector)vector, valueCount);
        } else if (vector instanceof TimeStampSecTZVector) {
            GenerateSampleData.writeTimeStampData((TimeStampSecTZVector)vector, valueCount);
        } else if (vector instanceof TimeStampMicroTZVector) {
            GenerateSampleData.writeTimeStampData((TimeStampMicroTZVector)vector, valueCount);
        } else if (vector instanceof TimeStampMilliTZVector) {
            GenerateSampleData.writeTimeStampData((TimeStampMilliTZVector)vector, valueCount);
        } else if (vector instanceof TimeStampNanoTZVector) {
            GenerateSampleData.writeTimeStampData((TimeStampNanoTZVector)vector, valueCount);
        } else if (vector instanceof UInt1Vector) {
            GenerateSampleData.writeUInt1Data((UInt1Vector)vector, valueCount);
        } else if (vector instanceof UInt2Vector) {
            GenerateSampleData.writeUInt2Data((UInt2Vector)vector, valueCount);
        } else if (vector instanceof UInt4Vector) {
            GenerateSampleData.writeUInt4Data((UInt4Vector)vector, valueCount);
        } else if (vector instanceof UInt8Vector) {
            GenerateSampleData.writeUInt8Data((UInt8Vector)vector, valueCount);
        }
    }

    private static void writeTimeStampData(TimeStampVector vector, int valueCount) {
        long even = 100000L;
        long odd = 200000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 100000L);
                continue;
            }
            vector.setSafe(i, 200000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeDecimalData(DecimalVector vector, int valueCount) {
        BigDecimal even = new BigDecimal("0.0543278923");
        BigDecimal odd = new BigDecimal("2.0543278923");
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, even);
                continue;
            }
            vector.setSafe(i, odd);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeIntData(IntVector vector, int valueCount) {
        int even = 1000;
        int odd = 2000;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000);
                continue;
            }
            vector.setSafe(i, 2000);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeBooleanData(BitVector vector, int valueCount) {
        boolean even = false;
        boolean odd = true;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 0);
                continue;
            }
            vector.setSafe(i, 1);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeIntervalYearData(IntervalYearVector vector, int valueCount) {
        boolean even = true;
        int odd = 2;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1);
                continue;
            }
            vector.setSafe(i, 2);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeIntervalDayData(IntervalDayVector vector, int valueCount) {
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1, 50);
                continue;
            }
            vector.setSafe(i, 2, 100);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeTimeSecData(TimeSecVector vector, int valueCount) {
        int even = 500;
        int odd = 900;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 500);
                continue;
            }
            vector.setSafe(i, 900);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeTimeMilliData(TimeMilliVector vector, int valueCount) {
        int even = 1000;
        int odd = 2000;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000);
                continue;
            }
            vector.setSafe(i, 2000);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeTimeMicroData(TimeMicroVector vector, int valueCount) {
        long even = 1000000000L;
        long odd = 2000000000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000000000L);
                continue;
            }
            vector.setSafe(i, 2000000000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeTimeNanoData(TimeNanoVector vector, int valueCount) {
        long even = 1000000000L;
        long odd = 2000000000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000000000L);
                continue;
            }
            vector.setSafe(i, 2000000000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeDateDayData(DateDayVector vector, int valueCount) {
        int even = 1000;
        int odd = 2000;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000);
                continue;
            }
            vector.setSafe(i, 2000);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeDateMilliData(DateMilliVector vector, int valueCount) {
        long even = 1000000000L;
        long odd = 2000000000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000000000L);
                continue;
            }
            vector.setSafe(i, 2000000000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeSmallIntData(SmallIntVector vector, int valueCount) {
        int even = 10;
        int odd = 20;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, (short)10);
                continue;
            }
            vector.setSafe(i, (short)20);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeTinyIntData(TinyIntVector vector, int valueCount) {
        boolean even = true;
        int odd = 2;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, (byte)1);
                continue;
            }
            vector.setSafe(i, (byte)2);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeUInt1Data(UInt1Vector vector, int valueCount) {
        boolean even = true;
        int odd = 2;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, (byte)1);
                continue;
            }
            vector.setSafe(i, (byte)2);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeUInt2Data(UInt2Vector vector, int valueCount) {
        int even = 10;
        int odd = 20;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 10);
                continue;
            }
            vector.setSafe(i, 20);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeUInt4Data(UInt4Vector vector, int valueCount) {
        int even = 1000;
        int odd = 2000;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000);
                continue;
            }
            vector.setSafe(i, 2000);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeUInt8Data(UInt8Vector vector, int valueCount) {
        long even = 1000000000L;
        long odd = 2000000000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000000000L);
                continue;
            }
            vector.setSafe(i, 2000000000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeBigIntData(BigIntVector vector, int valueCount) {
        long even = 1000000000L;
        long odd = 2000000000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000000000L);
                continue;
            }
            vector.setSafe(i, 2000000000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeFloatData(Float4Vector vector, int valueCount) {
        float even = 20.3f;
        float odd = 40.2f;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 20.3f);
                continue;
            }
            vector.setSafe(i, 40.2f);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeDoubleData(Float8Vector vector, int valueCount) {
        double even = 20.2373;
        double odd = 40.2378;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 20.2373);
                continue;
            }
            vector.setSafe(i, 40.2378);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeVarBinaryData(VarBinaryVector vector, int valueCount) {
        Charset utf8Charset = Charset.forName("UTF-8");
        byte[] even = "AAAAA1".getBytes(utf8Charset);
        byte[] odd = "BBBBBBBBB2".getBytes(utf8Charset);
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, even);
                continue;
            }
            vector.setSafe(i, odd);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeVarCharData(VarCharVector vector, int valueCount) {
        Charset utf8Charset = Charset.forName("UTF-8");
        byte[] even = "AAAAA1".getBytes(utf8Charset);
        byte[] odd = "BBBBBBBBB2".getBytes(utf8Charset);
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, even);
                continue;
            }
            vector.setSafe(i, odd);
        }
        vector.setValueCount(valueCount);
    }
}

