/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.wif;

import java.util.Collections;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestation;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestationCreator;
import net.snowflake.client.core.auth.wif.WorkloadIdentityProviderType;
import net.snowflake.client.core.auth.wif.WorkloadIdentityUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

@SnowflakeJdbcInternalApi
public class GcpIdentityAttestationCreator
implements WorkloadIdentityAttestationCreator {
    private static final String METADATA_FLAVOR_HEADER_NAME = "Metadata-Flavor";
    private static final String METADATA_FLAVOR = "Google";
    private static final String EXPECTED_GCP_TOKEN_ISSUER = "https://accounts.google.com";
    private static final String DEFAULT_GCP_METADATA_SERVICE_BASE_URL = "http://169.254.169.254";
    private final String gcpMetadataServiceBaseUrl;
    private static final SFLogger logger = SFLoggerFactory.getLogger(GcpIdentityAttestationCreator.class);
    private final SFLoginInput loginInput;

    public GcpIdentityAttestationCreator(SFLoginInput loginInput) {
        this.loginInput = loginInput;
        this.gcpMetadataServiceBaseUrl = DEFAULT_GCP_METADATA_SERVICE_BASE_URL;
    }

    GcpIdentityAttestationCreator(SFLoginInput loginInput, String gcpBaseUrl) {
        this.loginInput = loginInput;
        this.gcpMetadataServiceBaseUrl = gcpBaseUrl;
    }

    @Override
    public WorkloadIdentityAttestation createAttestation() {
        logger.debug("Creating GCP identity attestation...", new Object[0]);
        String token = this.fetchTokenFromMetadataService();
        if (token == null) {
            logger.debug("No GCP token was found.", new Object[0]);
            return null;
        }
        WorkloadIdentityUtil.SubjectAndIssuer claims = WorkloadIdentityUtil.extractClaimsWithoutVerifyingSignature(token);
        if (claims == null) {
            logger.error("Could not extract claims from token", new Object[0]);
            return null;
        }
        if (!EXPECTED_GCP_TOKEN_ISSUER.equalsIgnoreCase(claims.getIssuer())) {
            logger.error("Unexpected token issuer: {}, should be {}", claims.getIssuer(), EXPECTED_GCP_TOKEN_ISSUER);
            return null;
        }
        return new WorkloadIdentityAttestation(WorkloadIdentityProviderType.GCP, token, Collections.singletonMap("sub", claims.getSubject()));
    }

    private String fetchTokenFromMetadataService() {
        String uri = this.gcpMetadataServiceBaseUrl + "/computeMetadata/v1/instance/service-accounts/default/identity?audience=" + "snowflakecomputing.com";
        HttpGet tokenRequest = new HttpGet(uri);
        tokenRequest.setHeader(METADATA_FLAVOR_HEADER_NAME, METADATA_FLAVOR);
        try {
            return WorkloadIdentityUtil.performIdentityRequest((HttpRequestBase)tokenRequest, this.loginInput);
        }
        catch (Exception e) {
            logger.debug("GCP metadata server request was not successful: {}" + e, new Object[0]);
            return null;
        }
    }
}

