/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;

@SnowflakeJdbcInternalApi
public class SfTimestampUtil {
    static final long MS_IN_DAY = 86400000L;

    public static Timestamp getTimestampFromType(int columnSubType, String value, SFBaseSession session, TimeZone sessionTimeZone, TimeZone tz) {
        if (columnSubType == 50000) {
            return SfTimestampUtil.getTimestampFromFormat("TIMESTAMP_LTZ_OUTPUT_FORMAT", value, session, sessionTimeZone, tz);
        }
        if (columnSubType == 50002 || columnSubType == 93) {
            return SfTimestampUtil.getTimestampFromFormat("TIMESTAMP_NTZ_OUTPUT_FORMAT", value, session, sessionTimeZone, TimeZone.getDefault());
        }
        if (columnSubType == 50001) {
            return SfTimestampUtil.getTimestampFromFormat("TIMESTAMP_TZ_OUTPUT_FORMAT", value, session, sessionTimeZone, tz);
        }
        return null;
    }

    private static Timestamp getTimestampFromFormat(String format, String value, SFBaseSession session, TimeZone sessionTimeZone, TimeZone tz) {
        String rawFormat = (String)session.getCommonParameters().get(format);
        if (rawFormat == null || rawFormat.isEmpty()) {
            rawFormat = (String)session.getCommonParameters().get("TIMESTAMP_OUTPUT_FORMAT");
        }
        if (tz == null) {
            tz = sessionTimeZone;
        }
        SnowflakeDateTimeFormat formatter = SnowflakeDateTimeFormat.fromSqlFormat(rawFormat);
        return formatter.parse(value, tz, 0, false).getTimestamp();
    }

    public static long getTimeInNanoseconds(Time x) {
        long msSinceEpoch = x.getTime();
        long msSinceMidnight = (msSinceEpoch % 86400000L + 86400000L) % 86400000L;
        long nanosSinceMidnight = msSinceMidnight * 1000L * 1000L;
        return nanosSinceMidnight;
    }
}

