/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.SQLException;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.SFArrowResultSet;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFResultSet;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;

class SFResultSetFactory {
    SFResultSetFactory() {
    }

    static SFBaseResultSet getResultSet(JsonNode result, SFStatement statement, boolean sortResult, ExecTimeTelemetryData execTimeData) throws SQLException {
        SFBaseResultSet rs;
        execTimeData.setProcessResultChunkStart();
        SnowflakeResultSetSerializableV1 resultSetSerializable = SnowflakeResultSetSerializableV1.create(result, statement.getSFBaseSession(), statement);
        execTimeData.setProcessResultChunkEnd();
        execTimeData.setCreateResultSetStart();
        switch (resultSetSerializable.getQueryResultFormat()) {
            case ARROW: {
                rs = new SFArrowResultSet(resultSetSerializable, statement.getSFBaseSession(), statement, sortResult);
                break;
            }
            case JSON: {
                rs = new SFResultSet(resultSetSerializable, statement, sortResult);
                break;
            }
            default: {
                rs = null;
            }
        }
        execTimeData.setCreateResultSetEnd();
        if (rs == null) {
            throw new SnowflakeSQLLoggedException(statement.getSFBaseSession(), ErrorCode.INTERNAL_ERROR, "Unsupported query result format: " + resultSetSerializable.getQueryResultFormat().name());
        }
        return rs;
    }
}

