/*
 * Decompiled with CFR 0.152.
 */
package net.smartlab.web.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.sql.DriverManager;
import net.smartlab.web.BusinessObjectFactory;
import net.smartlab.web.config.ConfigurationStrategy;
import net.smartlab.web.config.FactoryConfigurationStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.DatabaseTestCase;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;

public abstract class ModelTestCase
extends DatabaseTestCase {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private DatabaseConnection connection;

    public ModelTestCase() {
    }

    public ModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"setUp() - start");
        }
        BusinessObjectFactory.setConfigurationStrategy((FactoryConfigurationStrategy)new TestConfiguration());
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"tearDown() - start");
        }
        BusinessObjectFactory.close();
        super.tearDown();
    }

    protected URL getConfigurationFile() throws Exception {
        return new File("res/smartweb.jar.hcf").toURL();
    }

    protected IDatabaseConnection getConnection() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getConnection() - start");
        }
        if (this.connection == null || this.connection.getConnection().isClosed()) {
            Configuration configuration = new Configuration().configure(this.getConfigurationFile());
            String driver = configuration.getProperty("hibernate.connection.driver_class");
            String url = configuration.getProperty("hibernate.connection.url");
            String username = configuration.getProperty("hibernate.connection.username");
            String password = configuration.getProperty("hibernate.connection.password");
            String dialectName = configuration.getProperty("dialect");
            Dialect dialect = DialectFactory.buildDialect((String)dialectName);
            Class.forName(driver);
            this.connection = new DatabaseConnection(DriverManager.getConnection(url, username, password));
            this.connection.getConfig().setFeature("http://www.dbunit.org/features/qualifiedTableNames", dialect.qualifyIndexName());
            this.connection.getConfig().setProperty("http://www.dbunit.org/properties/escapePattern", (Object)(dialect.openQuote() + "?" + dialect.closeQuote()));
        }
        return this.connection;
    }

    protected IDataSet getDataSet() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getDataSet() - start");
            this.logger.trace((Object)("  res = " + this.getDataSetFile()));
        }
        try {
            return new FlatXmlDataSet((InputStream)new FileInputStream(this.getDataSetFile()));
        }
        catch (Exception e) {
            this.logger.warn((Object)"getDataSet() - not found");
            return new DefaultDataSet();
        }
    }

    protected DatabaseOperation getSetUpOperation() throws Exception {
        return DatabaseOperation.REFRESH;
    }

    protected DatabaseOperation getTearDownOperation() throws Exception {
        return DatabaseOperation.NONE;
    }

    protected abstract String getDataSetFile();

    protected class TestConfiguration
    implements ConfigurationStrategy {
        private SessionFactory factory = null;

        protected TestConfiguration() {
        }

        public SessionFactory getSessionFactory(BusinessObjectFactory bof) {
            if (this.factory == null) {
                try {
                    Configuration configuration = new Configuration().configure(ModelTestCase.this.getConfigurationFile());
                    String driver = configuration.getProperty("hibernate.connection.driver_class");
                    String url = configuration.getProperty("hibernate.connection.url");
                    String username = configuration.getProperty("hibernate.connection.username");
                    String password = configuration.getProperty("hibernate.connection.password");
                    Class.forName(driver);
                    ModelTestCase.this.connection = new DatabaseConnection(DriverManager.getConnection(url, username, password));
                    this.factory = configuration.buildSessionFactory();
                }
                catch (Exception e) {
                    ModelTestCase.this.logger.error((Object)e);
                }
            }
            return this.factory;
        }
    }
}

