/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.NodeTest;
import org.custommonkey.xmlunit.NodeTestException;
import org.custommonkey.xmlunit.NodeTester;
import org.custommonkey.xmlunit.Validator;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XSLTConstants;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.ConfigurationException;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLAssertTestNG
implements XSLTConstants {
    protected XMLAssertTestNG() {
    }

    public static void assertXMLEqual(Diff diff, boolean assertion) {
        XMLAssertTestNG.assertXMLEqual(null, diff, assertion);
    }

    public static void assertXMLEqual(String msg, Diff diff, boolean assertion) {
        if (assertion != diff.similar()) {
            Assert.fail((String)XMLAssertTestNG.getFailMessage(msg, diff));
        }
    }

    private static String getFailMessage(String msg, Diff diff) {
        StringBuffer sb = new StringBuffer();
        if (msg != null && msg.length() > 0) {
            sb.append(msg).append(", ");
        }
        return sb.append(diff.toString()).toString();
    }

    public static void assertXMLIdentical(Diff diff, boolean assertion) {
        XMLAssertTestNG.assertXMLIdentical(null, diff, assertion);
    }

    public static void assertXMLIdentical(String msg, Diff diff, boolean assertion) {
        if (assertion != diff.identical()) {
            Assert.fail((String)XMLAssertTestNG.getFailMessage(msg, diff));
        }
    }

    public static void assertXMLEqual(InputSource control, InputSource test) throws SAXException, IOException {
        XMLAssertTestNG.assertXMLEqual(null, control, test);
    }

    public static void assertXMLEqual(String control, String test) throws SAXException, IOException {
        XMLAssertTestNG.assertXMLEqual(null, control, test);
    }

    public static void assertXMLEqual(Document control, Document test) {
        XMLAssertTestNG.assertXMLEqual(null, control, test);
    }

    public static void assertXMLEqual(Reader control, Reader test) throws SAXException, IOException {
        XMLAssertTestNG.assertXMLEqual(null, control, test);
    }

    public static void assertXMLEqual(String err, InputSource control, InputSource test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssertTestNG.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLEqual(String err, String control, String test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssertTestNG.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLEqual(String err, Document control, Document test) {
        Diff diff = new Diff(control, test);
        XMLAssertTestNG.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLEqual(String err, Reader control, Reader test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssertTestNG.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLNotEqual(InputSource control, InputSource test) throws SAXException, IOException {
        XMLAssertTestNG.assertXMLNotEqual(null, control, test);
    }

    public static void assertXMLNotEqual(String control, String test) throws SAXException, IOException {
        XMLAssertTestNG.assertXMLNotEqual(null, control, test);
    }

    public static void assertXMLNotEqual(Document control, Document test) {
        XMLAssertTestNG.assertXMLNotEqual(null, control, test);
    }

    public static void assertXMLNotEqual(Reader control, Reader test) throws SAXException, IOException {
        XMLAssertTestNG.assertXMLNotEqual(null, control, test);
    }

    public static void assertXMLNotEqual(String err, InputSource control, InputSource test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssertTestNG.assertXMLEqual(err, diff, false);
    }

    public static void assertXMLNotEqual(String err, String control, String test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssertTestNG.assertXMLEqual(err, diff, false);
    }

    public static void assertXMLNotEqual(String err, Document control, Document test) {
        Diff diff = new Diff(control, test);
        XMLAssertTestNG.assertXMLEqual(err, diff, false);
    }

    public static void assertXMLNotEqual(String err, Reader control, Reader test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssertTestNG.assertXMLEqual(err, diff, false);
    }

    public static void assertXpathsEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssertTestNG.assertXpathsEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathsEqual(String controlXpath, String testXpath, InputSource document) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathsEqual(controlXpath, testXpath, XMLUnit.buildControlDocument((InputSource)document));
    }

    public static void assertXpathsEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathsEqual(controlXpath, testXpath, XMLUnit.buildControlDocument((String)inXMLString));
    }

    public static void assertXpathsEqual(String controlXpath, InputSource controlDocument, String testXpath, InputSource testDocument) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathsEqual(controlXpath, XMLUnit.buildControlDocument((InputSource)controlDocument), testXpath, XMLUnit.buildTestDocument((InputSource)testDocument));
    }

    public static void assertXpathsEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathsEqual(controlXpath, XMLUnit.buildControlDocument((String)inControlXMLString), testXpath, XMLUnit.buildTestDocument((String)inTestXMLString));
    }

    public static void assertXpathsEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XMLAssertTestNG.assertXpathEquality(controlXpath, controlDocument, testXpath, testDocument, true);
    }

    public static void assertXpathsNotEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssertTestNG.assertXpathsNotEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathsNotEqual(String controlXpath, String testXpath, InputSource document) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathsNotEqual(controlXpath, testXpath, XMLUnit.buildControlDocument((InputSource)document));
    }

    public static void assertXpathsNotEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathsNotEqual(controlXpath, testXpath, XMLUnit.buildControlDocument((String)inXMLString));
    }

    public static void assertXpathsNotEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathsNotEqual(controlXpath, XMLUnit.buildControlDocument((String)inControlXMLString), testXpath, XMLUnit.buildTestDocument((String)inTestXMLString));
    }

    public static void assertXpathsNotEqual(String controlXpath, InputSource controlDocument, String testXpath, InputSource testDocument) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathsNotEqual(controlXpath, XMLUnit.buildControlDocument((InputSource)controlDocument), testXpath, XMLUnit.buildTestDocument((InputSource)testDocument));
    }

    public static void assertXpathsNotEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XMLAssertTestNG.assertXpathEquality(controlXpath, controlDocument, testXpath, testDocument, false);
    }

    private static void assertXpathEquality(String controlXpath, Document controlDocument, String testXpath, Document testDocument, boolean equal) throws XpathException {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Diff diff = new Diff(XMLAssertTestNG.asXpathResultDocument(XMLUnit.newControlParser(), xpath.getMatchingNodes(controlXpath, controlDocument)), XMLAssertTestNG.asXpathResultDocument(XMLUnit.newTestParser(), xpath.getMatchingNodes(testXpath, testDocument)));
        XMLAssertTestNG.assertXMLEqual(diff, equal);
    }

    public static void assertXpathValuesEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssertTestNG.assertXpathValuesEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathValuesEqual(String controlXpath, String testXpath, InputSource document) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathValuesEqual(controlXpath, testXpath, XMLUnit.buildControlDocument((InputSource)document));
    }

    public static void assertXpathValuesEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathValuesEqual(controlXpath, testXpath, XMLUnit.buildControlDocument((String)inXMLString));
    }

    public static void assertXpathValuesEqual(String controlXpath, InputSource control, String testXpath, InputSource test) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathValuesEqual(controlXpath, XMLUnit.buildControlDocument((InputSource)control), testXpath, XMLUnit.buildTestDocument((InputSource)test));
    }

    public static void assertXpathValuesEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathValuesEqual(controlXpath, XMLUnit.buildControlDocument((String)inControlXMLString), testXpath, XMLUnit.buildTestDocument((String)inTestXMLString));
    }

    public static void assertXpathValuesEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((String)xpath.evaluate(controlXpath, controlDocument), (String)xpath.evaluate(controlXpath, controlDocument));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String testXpath, InputSource control) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathValuesNotEqual(controlXpath, testXpath, XMLUnit.buildControlDocument((InputSource)control));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathValuesNotEqual(controlXpath, testXpath, XMLUnit.buildControlDocument((String)inXMLString));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssertTestNG.assertXpathValuesNotEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathValuesNotEqual(String controlXpath, InputSource control, String testXpath, InputSource test) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathValuesNotEqual(controlXpath, XMLUnit.buildControlDocument((InputSource)control), testXpath, XMLUnit.buildTestDocument((InputSource)test));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssertTestNG.assertXpathValuesNotEqual(controlXpath, XMLUnit.buildControlDocument((String)inControlXMLString), testXpath, XMLUnit.buildTestDocument((String)inTestXMLString));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String control = xpath.evaluate(controlXpath, controlDocument);
        String test = xpath.evaluate(testXpath, testDocument);
        if (control != null) {
            if (control.equals(test)) {
                Assert.fail((String)("Expected test value NOT to be equal to control but both were " + test));
            }
        } else if (test != null) {
            Assert.fail((String)("control xPath evaluated to empty node set, but test xPath evaluated to " + test));
        }
    }

    public static void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, InputSource control) throws SAXException, IOException, XpathException {
        Document document = XMLUnit.buildControlDocument((InputSource)control);
        XMLAssertTestNG.assertXpathEvaluatesTo(expectedValue, xpathExpression, document);
    }

    public static void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, String inXMLString) throws SAXException, IOException, XpathException {
        Document document = XMLUnit.buildControlDocument((String)inXMLString);
        XMLAssertTestNG.assertXpathEvaluatesTo(expectedValue, xpathExpression, document);
    }

    public static void assertXpathEvaluatesTo(String expectedValue, String xPathExpression, Document inDocument) throws XpathException {
        XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
        Assert.assertEquals((String)simpleXpathEngine.evaluate(xPathExpression, inDocument), (String)expectedValue);
    }

    public static void assertXpathExists(String xPathExpression, InputSource control) throws IOException, SAXException, XpathException {
        Document inDocument = XMLUnit.buildControlDocument((InputSource)control);
        XMLAssertTestNG.assertXpathExists(xPathExpression, inDocument);
    }

    public static void assertXpathExists(String xPathExpression, String inXMLString) throws IOException, SAXException, XpathException {
        Document inDocument = XMLUnit.buildControlDocument((String)inXMLString);
        XMLAssertTestNG.assertXpathExists(xPathExpression, inDocument);
    }

    public static void assertXpathExists(String xPathExpression, Document inDocument) throws XpathException {
        XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
        NodeList nodeList = simpleXpathEngine.getMatchingNodes(xPathExpression, inDocument);
        int matches = nodeList.getLength();
        Assert.assertTrue((matches > 0 ? 1 : 0) != 0, (String)("Expecting to find matches for Xpath " + xPathExpression));
    }

    public static void assertXpathNotExists(String xPathExpression, InputSource control) throws IOException, SAXException, XpathException {
        Document inDocument = XMLUnit.buildControlDocument((InputSource)control);
        XMLAssertTestNG.assertXpathNotExists(xPathExpression, inDocument);
    }

    public static void assertXpathNotExists(String xPathExpression, String inXMLString) throws IOException, SAXException, XpathException {
        Document inDocument = XMLUnit.buildControlDocument((String)inXMLString);
        XMLAssertTestNG.assertXpathNotExists(xPathExpression, inDocument);
    }

    public static void assertXpathNotExists(String xPathExpression, Document inDocument) throws XpathException {
        XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
        NodeList nodeList = simpleXpathEngine.getMatchingNodes(xPathExpression, inDocument);
        int matches = nodeList.getLength();
        Assert.assertEquals((int)matches, (int)0, (String)("Should be zero matches for Xpath " + xPathExpression));
    }

    public static void assertXMLValid(InputSource xml) throws SAXException, ConfigurationException {
        XMLAssertTestNG.assertXMLValid(new Validator(xml));
    }

    public static void assertXMLValid(String xmlString) throws SAXException, ConfigurationException {
        XMLAssertTestNG.assertXMLValid(new Validator(xmlString));
    }

    public static void assertXMLValid(InputSource xml, String systemId) throws SAXException, ConfigurationException {
        XMLAssertTestNG.assertXMLValid(new Validator(xml, systemId));
    }

    public static void assertXMLValid(String xmlString, String systemId) throws SAXException, ConfigurationException {
        XMLAssertTestNG.assertXMLValid(new Validator(xmlString, systemId));
    }

    public static void assertXMLValid(InputSource xml, String systemId, String doctype) throws SAXException, ConfigurationException {
        XMLAssertTestNG.assertXMLValid(new Validator(xml, systemId, doctype));
    }

    public static void assertXMLValid(String xmlString, String systemId, String doctype) throws SAXException, ConfigurationException {
        XMLAssertTestNG.assertXMLValid(new Validator((Reader)new StringReader(xmlString), systemId, doctype));
    }

    public static void assertXMLValid(Validator validator) {
        Assert.assertEquals((boolean)validator.isValid(), (boolean)true, (String)validator.toString());
    }

    public static void assertNodeTestPasses(InputSource xml, NodeTester tester, short nodeType) throws SAXException, IOException {
        NodeTest test = new NodeTest(xml);
        XMLAssertTestNG.assertNodeTestPasses(test, tester, new short[]{nodeType}, true);
    }

    public static void assertNodeTestPasses(String xmlString, NodeTester tester, short nodeType) throws SAXException, IOException {
        NodeTest test = new NodeTest(xmlString);
        XMLAssertTestNG.assertNodeTestPasses(test, tester, new short[]{nodeType}, true);
    }

    public static void assertNodeTestPasses(NodeTest test, NodeTester tester, short[] nodeTypes, boolean assertion) {
        block3: {
            try {
                test.performTest(tester, nodeTypes);
                if (!assertion) {
                    Assert.fail((String)"Expected node test to fail, but it passed!");
                }
            }
            catch (NodeTestException e) {
                if (!assertion) break block3;
                Assert.fail((String)("Expected node test to pass, but it failed! " + e.getMessage()));
            }
        }
    }

    private static Document asXpathResultDocument(DocumentBuilder builder, NodeList nodes) {
        Document d = builder.newDocument();
        Element root = d.createElement("xpathResult");
        d.appendChild(root);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            root.appendChild(d.importNode(nodes.item(i), true));
        }
        return d;
    }
}

