/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.shibboleth.utilities.java.support.httpclient.ContextHandlingHttpClient;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ContextHandlingHttpClientTest {
    public static final CloseableHttpResponse STATIC_RESPONSE_HTTP = new MockCloseableHttpResponse(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
    public static final Object STATIC_RESPONSE_HANDLER = new Object();
    private ContextHandlingHttpClient client;
    private TestContextHandler staticOne;
    private TestContextHandler staticTwo;
    private TestContextHandler staticThree;
    private TestContextHandler dynamicOne;
    private TestContextHandler dynamicTwo;
    private TestContextHandler dynamicThree;
    private HttpClientContext context;
    private HttpUriRequest request;
    private HttpHost target;
    private ResponseHandler<Object> responseHandler = new MockResponseHandler();

    @BeforeClass
    public void setupClass() {
        this.staticOne = new TestContextHandler("static-1");
        this.staticTwo = new TestContextHandler("static-2");
        this.staticThree = new TestContextHandler("static-3");
        this.dynamicOne = new TestContextHandler("dynamic-1");
        this.dynamicTwo = new TestContextHandler("dynamic-2");
        this.dynamicThree = new TestContextHandler("dynamic-3");
    }

    @BeforeMethod
    public void setupMethod() {
        this.request = new HttpGet("/test");
        this.target = new HttpHost("test.example.edu");
    }

    @Test
    public void testNoHandlers() throws ClientProtocolException, IOException {
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient());
        this.context = HttpClientContext.create();
        Assert.assertSame((Object)this.client.execute(this.request), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertSame((Object)this.client.execute(this.request, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertSame((Object)this.client.execute(this.target, (HttpRequest)this.request), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertSame((Object)this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertSame((Object)this.client.execute(this.request, this.responseHandler, (HttpContext)this.context), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertSame((Object)this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertSame((Object)this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context), (Object)STATIC_RESPONSE_HANDLER);
    }

    @Test
    public void testStaticOnly() throws ClientProtocolException, IOException {
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "after-static-3", "after-static-2", "after-static-1"});
        this.context = HttpClientContext.create();
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        this.context = HttpClientContext.create();
        Assert.assertSame((Object)this.client.execute(this.request, this.responseHandler, (HttpContext)this.context), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        this.context = HttpClientContext.create();
        Assert.assertSame((Object)this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        this.context = HttpClientContext.create();
        Assert.assertSame((Object)this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
    }

    @Test
    public void testDynamicOnly() throws ClientProtocolException, IOException {
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient());
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        this.context = HttpClientContext.create();
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        this.context = HttpClientContext.create();
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.request, this.responseHandler, (HttpContext)this.context), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        this.context = HttpClientContext.create();
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        this.context = HttpClientContext.create();
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
    }

    @Test
    public void testStaticAndDynamic() throws ClientProtocolException, IOException {
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        this.context = HttpClientContext.create();
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        this.context = HttpClientContext.create();
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.request, this.responseHandler, (HttpContext)this.context), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        this.context = HttpClientContext.create();
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        this.context = HttpClientContext.create();
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
    }

    @Test
    public void testWrappedClientThrowsIOException() throws ClientProtocolException, IOException {
        IOException error = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(error), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testWrappedClientThrowsRuntimeException() throws ClientProtocolException, IOException {
        RuntimeException error = new RuntimeException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(error), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testWrappedClientThrowsError() throws ClientProtocolException, IOException {
        Error error = new Error();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(error), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (Error e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (Error e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (Error e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (Error e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleStaticHandlerInvokeBeforeThrowsIOException() throws ClientProtocolException, IOException {
        IOException error = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", error, null), this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleStaticHandlerInvokeAfterThrowsIOException() throws ClientProtocolException, IOException {
        IOException error = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", null, error), this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleStaticHandlerInvokeBeforeThrowsRuntimeException() throws ClientProtocolException, IOException {
        RuntimeException error = new RuntimeException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", error, null), this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleStaticHandlerInvokeAfterThrowsRuntimeException() throws ClientProtocolException, IOException {
        RuntimeException error = new RuntimeException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", null, error), this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleStaticHandlersInvokeBeforeThrowIOException() throws ClientProtocolException, IOException {
        IOException error1 = new IOException();
        IOException error3 = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{new TestContextHandler("static-1", error1, null), this.staticTwo, new TestContextHandler("static-3", error3, null)}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleStaticHandlersInvokeBeforeThrowRuntimeException() throws ClientProtocolException, IOException {
        RuntimeException error1 = new RuntimeException();
        RuntimeException error3 = new RuntimeException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{new TestContextHandler("static-1", error1, null), this.staticTwo, new TestContextHandler("static-3", error3, null)}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleStaticHandlersInvokeAfterThrowIOException() throws ClientProtocolException, IOException {
        IOException error1 = new IOException();
        IOException error3 = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{new TestContextHandler("static-1", null, error1), this.staticTwo, new TestContextHandler("static-3", null, error3)}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleStaticHandlersInvokeAfterThrowRuntimeException() throws ClientProtocolException, IOException {
        RuntimeException error1 = new RuntimeException();
        RuntimeException error3 = new RuntimeException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{new TestContextHandler("static-1", null, error1), this.staticTwo, new TestContextHandler("static-3", null, error3)}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleDynamicHandlerInvokeBeforeThrowsIOException() throws ClientProtocolException, IOException {
        IOException error = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", error, null), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleDynamicHandlerInvokeAfterThrowsIOException() throws ClientProtocolException, IOException {
        IOException error = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, error), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleDynamicHandlerInvokeBeforeThrowsRuntimeException() throws ClientProtocolException, IOException {
        RuntimeException error = new RuntimeException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", error, null), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleDynamicHandlerInvokeAfterThrowsRuntimeException() throws ClientProtocolException, IOException {
        RuntimeException error = new RuntimeException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, error), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleDynamicHandlersInvokeBeforeThrowIOException() throws ClientProtocolException, IOException {
        IOException error1 = new IOException();
        IOException error3 = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{new TestContextHandler("dynamic-1", error1, null), this.dynamicTwo, new TestContextHandler("dynamic-3", error3, null)});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleDynamicHandlersInvokeBeforeThrowRuntimeException() throws ClientProtocolException, IOException {
        RuntimeException error1 = new RuntimeException();
        RuntimeException error3 = new RuntimeException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{new TestContextHandler("dynamic-1", error1, null), this.dynamicTwo, new TestContextHandler("dynamic-3", error3, null)});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleDynamicHandlersInvokeAfterThrowIOException() throws ClientProtocolException, IOException {
        IOException error1 = new IOException();
        IOException error3 = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{new TestContextHandler("dynamic-1", null, error1), this.dynamicTwo, new TestContextHandler("dynamic-3", null, error3)});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new IOException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleDynamicHandlersInvokeAfterThrowRuntimeException() throws ClientProtocolException, IOException {
        RuntimeException error1 = new RuntimeException();
        RuntimeException error3 = new RuntimeException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{new TestContextHandler("dynamic-1", null, error1), this.dynamicTwo, new TestContextHandler("dynamic-3", null, error3)});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(Lists.newArrayList((Object[])new RuntimeException[]{error1, error3})));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testStaticAndDynamicHandlersThrowIOException() throws ClientProtocolException, IOException {
        IOException staticBeforeError = null;
        IOException dynamicAfterError = null;
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList dynamicHandlers = null;
        staticBeforeError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", staticBeforeError, null), this.staticThree}));
        dynamicHandlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        staticBeforeError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", staticBeforeError, null), this.staticThree}));
        dynamicHandlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        staticBeforeError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", staticBeforeError, null), this.staticThree}));
        dynamicHandlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        staticBeforeError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", staticBeforeError, null), this.staticThree}));
        dynamicHandlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testStaticAndDynamicHandlersThrowRuntimeException() throws ClientProtocolException, IOException {
        RuntimeException staticBeforeError = new RuntimeException();
        RuntimeException dynamicAfterError = new RuntimeException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", staticBeforeError, null), this.staticThree}));
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList handlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0].getCause(), (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0].getCause(), (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0].getCause(), (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0].getCause(), (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testWrappedClientThrowsIOExceptionInvokeAfterThrowsIOException() throws ClientProtocolException, IOException {
        IOException clientError = null;
        IOException dynamicAfterError = null;
        ArrayList control = Lists.newArrayList((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        ArrayList dynamicHandlers = null;
        clientError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(clientError), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        dynamicHandlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)clientError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        clientError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(clientError), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        dynamicHandlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)clientError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        clientError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(clientError), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        dynamicHandlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.target, (HttpRequest)this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)clientError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        clientError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((CloseableHttpClient)new MockHttpClient(clientError), (List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        dynamicHandlers = Lists.newArrayList((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.target, (HttpRequest)this.request, this.responseHandler, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)clientError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    public static class ThrowableHelper {
        public static void checkAndThrowError(Throwable t) throws IOException {
            if (t != null) {
                if (IOException.class.isInstance(t)) {
                    throw (IOException)IOException.class.cast(t);
                }
                if (RuntimeException.class.isInstance(t)) {
                    throw (RuntimeException)RuntimeException.class.cast(t);
                }
                if (Error.class.isInstance(t)) {
                    throw (Error)Error.class.cast(t);
                }
            }
        }
    }

    public static class MockCloseableHttpResponse
    extends BasicHttpResponse
    implements CloseableHttpResponse {
        public MockCloseableHttpResponse(ProtocolVersion ver, int code, String reason) {
            super(ver, code, reason);
        }

        public void close() throws IOException {
        }
    }

    public static class MockResponseHandler
    implements ResponseHandler<Object> {
        public Object handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            return STATIC_RESPONSE_HANDLER;
        }
    }

    private static class MockHttpClient
    extends CloseableHttpClient {
        private Throwable error;

        public MockHttpClient() {
        }

        public MockHttpClient(Throwable throwable) {
            this.error = throwable;
        }

        public HttpParams getParams() {
            return null;
        }

        public ClientConnectionManager getConnectionManager() {
            return null;
        }

        public void close() throws IOException {
        }

        protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            ThrowableHelper.checkAndThrowError(this.error);
            return STATIC_RESPONSE_HTTP;
        }
    }

    private class TestContextHandler
    implements HttpClientContextHandler {
        public static final String TEST_KEY = "testKey";
        private String name;
        private Throwable invokeBeforeError;
        private Throwable invokeAfterError;

        public TestContextHandler(String instanceName) {
            this.name = instanceName;
        }

        public TestContextHandler(Throwable beforeError, Throwable afterError) {
            this.invokeBeforeError = beforeError;
            this.invokeAfterError = afterError;
        }

        public TestContextHandler(String instanceName, Throwable beforeError, Throwable afterError) {
            this.name = instanceName;
            this.invokeBeforeError = beforeError;
            this.invokeAfterError = afterError;
        }

        public void invokeBefore(HttpClientContext context, HttpUriRequest request) throws IOException {
            if (this.name != null) {
                this.addValue(context, "before-" + this.name);
            }
            ThrowableHelper.checkAndThrowError(this.invokeBeforeError);
        }

        public void invokeAfter(HttpClientContext context, HttpUriRequest request) throws IOException {
            if (this.name != null) {
                this.addValue(context, "after-" + this.name);
            }
            ThrowableHelper.checkAndThrowError(this.invokeAfterError);
        }

        private void addValue(HttpClientContext context, String value) {
            ArrayList<String> attrib = (ArrayList<String>)context.getAttribute(TEST_KEY, List.class);
            if (attrib == null) {
                attrib = new ArrayList<String>();
                context.setAttribute(TEST_KEY, attrib);
            }
            attrib.add(value);
        }
    }
}

