/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.codec;

import net.shibboleth.utilities.java.support.codec.HTMLEncoder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HTMLEncoderTest {
    @Test
    public void testEncodeForHTML() throws Exception {
        Assert.assertEquals((String)HTMLEncoder.encodeForHTML(null), null);
        Assert.assertEquals((String)HTMLEncoder.encodeForHTML((String)"a\u0000b\u0004c\u0080d\u0096e\u009ff\tg"), (String)"a&#xfffd;b&#xfffd;c&#xfffd;d&#xfffd;e&#xfffd;f&#x9;g");
        Assert.assertEquals((String)HTMLEncoder.encodeForHTML((String)"<script>"), (String)"&lt;script&gt;");
        Assert.assertEquals((String)HTMLEncoder.encodeForHTML((String)"&lt;script&gt;"), (String)"&amp;lt&#x3b;script&amp;gt&#x3b;");
        Assert.assertEquals((String)HTMLEncoder.encodeForHTML((String)"!@$%()=+{}[]"), (String)"&#x21;&#x40;&#x24;&#x25;&#x28;&#x29;&#x3d;&#x2b;&#x7b;&#x7d;&#x5b;&#x5d;");
        Assert.assertEquals((String)HTMLEncoder.encodeForHTML((String)",.-_ "), (String)",.-_ ");
        Assert.assertEquals((String)HTMLEncoder.encodeForHTML((String)"dir&"), (String)"dir&amp;");
        Assert.assertEquals((String)HTMLEncoder.encodeForHTML((String)"one&two"), (String)"one&amp;two");
        Assert.assertEquals((String)"\u3039\ufffd\u04dc", (String)"\u3039\ufffd\u04dc");
        Assert.assertEquals((String)HTMLEncoder.encodeForHTML((String)"http://example.org/response"), (String)"http&#x3a;&#x2f;&#x2f;example.org&#x2f;response");
    }

    @Test
    public void testEncodeForHTMLAttribute() {
        Assert.assertEquals((String)HTMLEncoder.encodeForHTMLAttribute(null), null);
        Assert.assertEquals((String)HTMLEncoder.encodeForHTMLAttribute((String)"<script>"), (String)"&lt;script&gt;");
        Assert.assertEquals((String)HTMLEncoder.encodeForHTMLAttribute((String)",.-_"), (String)",.-_");
        Assert.assertEquals((String)HTMLEncoder.encodeForHTMLAttribute((String)" !@$%()=+{}[]"), (String)"&#x20;&#x21;&#x40;&#x24;&#x25;&#x28;&#x29;&#x3d;&#x2b;&#x7b;&#x7d;&#x5b;&#x5d;");
        Assert.assertEquals((String)HTMLEncoder.encodeForHTMLAttribute((String)"http://example.org/response"), (String)"http&#x3a;&#x2f;&#x2f;example.org&#x2f;response");
    }
}

