/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.codec;

import net.shibboleth.utilities.java.support.codec.Base64Support;
import org.testng.Assert;
import org.testng.annotations.Test;

public class Base64SupportTest {
    private static final String PLAIN_TEXT = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean malesuada, eros tempor aliquam ullamcorper, mauris velit iaculis metus, quis vulputate diam quam";
    private static final String UNCHUNCKED_ENCODED_TEXT = "TG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC4gQWVuZWFuIG1hbGVzdWFkYSwgZXJvcyB0ZW1wb3IgYWxpcXVhbSB1bGxhbWNvcnBlciwgbWF1cmlzIHZlbGl0IGlhY3VsaXMgbWV0dXMsIHF1aXMgdnVscHV0YXRlIGRpYW0gcXVhbQ==";
    private static final String CHUNCKED_ENCODED_TEXT = "TG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC4g\nQWVuZWFuIG1hbGVzdWFkYSwgZXJvcyB0ZW1wb3IgYWxpcXVhbSB1bGxhbWNvcnBlciwgbWF1cmlz\nIHZlbGl0IGlhY3VsaXMgbWV0dXMsIHF1aXMgdnVscHV0YXRlIGRpYW0gcXVhbQ==";

    @Test
    public void testEncode() {
        Assert.assertEquals((String)Base64Support.encode((byte[])PLAIN_TEXT.getBytes(), (boolean)false), (String)UNCHUNCKED_ENCODED_TEXT);
        Assert.assertEquals((String)Base64Support.encode((byte[])PLAIN_TEXT.getBytes(), (boolean)true), (String)CHUNCKED_ENCODED_TEXT);
    }

    @Test
    public void testDecode() {
        Assert.assertEquals((String)new String(Base64Support.decode((String)UNCHUNCKED_ENCODED_TEXT)), (String)PLAIN_TEXT);
        Assert.assertEquals((String)new String(Base64Support.decode((String)CHUNCKED_ENCODED_TEXT)), (String)PLAIN_TEXT);
    }
}

