/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;

public class ConditionalResource
extends AbstractIdentifiedInitializableComponent
implements org.springframework.core.io.Resource,
BeanNameAware,
Resource {
    @Nonnull
    @NotEmpty
    private static final String EMPTY_RESOURCE = "<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\"></beans>";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ConditionalResource.class);
    @Nullable
    private String logPrefix;
    @Nonnull
    private final org.springframework.core.io.Resource wrappedResource;

    public ConditionalResource(@Nonnull org.springframework.core.io.Resource wrapped) {
        this.wrappedResource = (org.springframework.core.io.Resource)Constraint.isNotNull((Object)wrapped, (String)"Wrapped resource cannot be null");
    }

    public void setId(@Nonnull @NotEmpty String id) {
        super.setId(id);
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.wrappedResource.getInputStream();
        }
        catch (IOException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("{} getInputStream failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            } else {
                this.log.debug("{} getInputStream failed on wrapped resource", (Object)this.getLogPrefix());
            }
            return new ByteArrayInputStream(EMPTY_RESOURCE.getBytes(StandardCharsets.UTF_8));
        }
    }

    public Resource createRelativeResource(String relativePath) throws IOException {
        org.springframework.core.io.Resource relative = this.wrappedResource.createRelative(relativePath);
        if (relative instanceof Resource) {
            return (Resource)relative;
        }
        return ResourceHelper.of(relative);
    }

    public void setBeanName(String name) {
        this.setId(name);
    }

    public boolean exists() {
        if (!this.wrappedResource.exists()) {
            this.log.debug("{} Wrapped resource does not exist", (Object)this.getLogPrefix());
        }
        return true;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isOpen() {
        return this.wrappedResource.isOpen();
    }

    public URL getURL() throws IOException {
        try {
            return this.wrappedResource.getURL();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} getURL failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return null;
        }
    }

    public URI getURI() throws IOException {
        try {
            return this.wrappedResource.getURI();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} getURI failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return null;
        }
    }

    public File getFile() throws IOException {
        try {
            return this.wrappedResource.getFile();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} getFile failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return null;
        }
    }

    public long contentLength() throws IOException {
        try {
            return this.wrappedResource.contentLength();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} contentLength failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return EMPTY_RESOURCE.length();
        }
    }

    public long lastModified() throws IOException {
        try {
            return this.wrappedResource.lastModified();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} lastModified failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return 0L;
        }
    }

    public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
        return this.wrappedResource.createRelative(relativePath);
    }

    public String getFilename() {
        return this.wrappedResource.getFilename();
    }

    public String getDescription() {
        return this.wrappedResource.getDescription();
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (this.logPrefix == null) {
            this.logPrefix = "ConditionalResource " + this.getId() + ":";
        }
        return this.logPrefix;
    }
}

