/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.context;

import javax.annotation.Nonnull;
import net.shibboleth.ext.spring.resource.ConditionalResourceResolver;
import net.shibboleth.ext.spring.util.AnnotationParameterNameDiscoverer;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class FileSystemXmlWebApplicationContext
extends XmlWebApplicationContext {
    public FileSystemXmlWebApplicationContext() {
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    protected Resource getResourceByPath(String path) {
        FileSystemResource r = new FileSystemResource(path);
        if (r.exists()) {
            return r;
        }
        return super.getResourceByPath(path);
    }

    public Resource getResource(@Nonnull String location) {
        Constraint.isNotNull((Object)location, (String)"Location must not be null");
        if (location.startsWith("classpath*:")) {
            return new ClassPathResource(location.substring("classpath*:".length()), this.getClassLoader());
        }
        return super.getResource(location);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory result = super.createBeanFactory();
        result.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        return result;
    }
}

