/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.service;

import java.io.IOException;
import java.util.Collections;
import net.shibboleth.ext.spring.service.NonReloadableTestBean;
import net.shibboleth.ext.spring.service.ReloadableTestBean;
import net.shibboleth.ext.spring.util.ApplicationContextBuilder;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReloadableBeanServiceTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reloadableService() throws IOException, InterruptedException {
        try (GenericApplicationContext appCtx = new ApplicationContextBuilder().setName("appCtx").setServiceConfigurations(Collections.singletonList(new ClassPathResource("net/shibboleth/ext/spring/service/ReloadableBeans1.xml"))).build();){
            NonReloadableTestBean bean = (NonReloadableTestBean)((Object)appCtx.getBean("nonReloadableBean", NonReloadableTestBean.class));
            Assert.assertEquals((int)10, (int)bean.getValue());
            ReloadableTestBean child1 = bean.getChild();
            ReloadableService embedded = (ReloadableService)appCtx.getBean("reloadableBeanService");
            ServiceableComponent component = embedded.getServiceableComponent();
            try {
                Assert.assertFalse((boolean)((ApplicationContext)component.getComponent()).containsLocalBean("reloadableBeanService"));
            }
            finally {
                component.unpinComponent();
            }
            embedded.reload();
            ReloadableTestBean child2 = bean.getChild();
            Assert.assertNotSame((Object)((Object)child1), (Object)((Object)child2));
        }
    }
}

