/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.Collection;
import net.shibboleth.ext.spring.resource.ResourceTestHelper;
import net.shibboleth.ext.spring.resource.RunnableFileSystemResource;
import net.shibboleth.ext.spring.resource.SVNRunnable;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.env.MockPropertySource;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNClientManager;

public class SVNRunnableTest {
    private static final String ORIGINAL_TEXT = "This is a Test Resource which will be superseded by other Data";
    private static final int ORIGINAL_VERSION = 1;
    private static final String PATH = "net/shibboleth/ext/spring/resource/";
    private static final String FILENAME = "TestResource.txt";
    private static final String CLASSPATH_PATH = "net/shibboleth/ext/spring/resource/TestResource.txt";
    private SVNClientManager clientManager;
    private Resource comparer = new ClassPathResource("net/shibboleth/ext/spring/resource/TestResource.txt");
    private SVNURL url;
    private File theDir;

    @BeforeClass
    public void setup() throws SVNException, IOException {
        BasicAuthenticationManager authnManager = new BasicAuthenticationManager(null);
        this.clientManager = SVNClientManager.newInstance();
        this.clientManager.setAuthenticationManager((ISVNAuthenticationManager)authnManager);
        String theDirPath = new ClassPathResource(PATH).getFile().getAbsolutePath();
        this.url = SVNURL.create((String)"file", null, (String)"", (int)-1, (String)(theDirPath + "/SVN"), (boolean)false);
    }

    @BeforeMethod
    public void makeDir() throws IOException {
        Path p = Files.createTempDirectory("SVNRunnableTest", new FileAttribute[0]);
        this.theDir = p.toFile();
    }

    private void emptyDir(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.emptyDir(f);
            }
            f.delete();
        }
    }

    @AfterMethod
    public void emptyDir() {
        this.emptyDir(this.theDir);
        this.theDir.delete();
        this.theDir = null;
    }

    private Resource makeResource(SVNClientManager svnClientMgr, SVNURL repositoryUrl, File workingCopy, long workingRevision, String resourceFile) {
        SVNRunnable runnable = new SVNRunnable(svnClientMgr, repositoryUrl, workingCopy, workingRevision);
        return new RunnableFileSystemResource(new File(workingCopy, resourceFile), (Runnable)runnable);
    }

    @Test(enabled=true)
    public void testRevision() throws IOException, ParseException {
        Resource resource = this.makeResource(this.clientManager, this.url, this.theDir, 1L, FILENAME);
        Assert.assertTrue((boolean)resource.exists());
        ByteArrayResource other = new ByteArrayResource(ORIGINAL_TEXT.getBytes());
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)other, resource));
        Assert.assertFalse((boolean)ResourceTestHelper.compare(this.comparer, resource));
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)other, resource));
    }

    @Test(enabled=true)
    public void testNotExist() {
        Resource resource = this.makeResource(this.clientManager, this.url, this.theDir, 0L, FILENAME);
        Assert.assertFalse((boolean)resource.exists());
    }

    @Test(enabled=true)
    public void testMain() throws IOException {
        Resource resource = this.makeResource(this.clientManager, this.url, this.theDir, -1L, FILENAME);
        Assert.assertTrue((boolean)resource.exists());
        Assert.assertTrue((boolean)ResourceTestHelper.compare(this.comparer, resource));
    }

    private GenericApplicationContext getContext(String fileName) {
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        parentContext.getBeanFactory().registerSingleton("theDir", (Object)this.theDir);
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions(fileName);
        MockPropertySource mockEnvVars = new MockPropertySource();
        mockEnvVars.setProperty("the.SVN.Dir", (Object)this.url.getPath());
        MutablePropertySources propertySources = context.getEnvironment().getPropertySources();
        propertySources.replace("systemProperties", (PropertySource)mockEnvVars);
        PropertySourcesPlaceholderConfigurer placeholderConfig = new PropertySourcesPlaceholderConfigurer();
        placeholderConfig.setPlaceholderPrefix("%{");
        placeholderConfig.setPlaceholderSuffix("}");
        placeholderConfig.setPropertySources((PropertySources)propertySources);
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)placeholderConfig);
        context.refresh();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSpringLoad() {
        GenericApplicationContext context = this.getContext("classpath:net/shibboleth/ext/spring/resource/SVNBean.xml");
        try {
            Collection beans = context.getBeansOfType(Resource.class).values();
            Assert.assertEquals((int)beans.size(), (int)1);
            Resource r = (Resource)beans.iterator().next();
            Assert.assertTrue((boolean)r.exists());
        }
        finally {
            ((GenericApplicationContext)context.getParent()).close();
            context.close();
        }
    }
}

