/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseSpringNamespaceHandler
implements NamespaceHandler {
    private final Logger log = LoggerFactory.getLogger(BaseSpringNamespaceHandler.class);
    private Map<QName, BeanDefinitionParser> parsers = new HashMap<QName, BeanDefinitionParser>();
    private Map<QName, BeanDefinitionDecorator> decorators = new HashMap<QName, BeanDefinitionDecorator>();
    private Map<QName, BeanDefinitionDecorator> attributeDecorators = new HashMap<QName, BeanDefinitionDecorator>();

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        return this.findDecoratorForNode(node).decorate(node, definition, parserContext);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        return this.findParserForElement(element).parse(element, parserContext);
    }

    protected BeanDefinitionParser findParserForElement(Element element) {
        BeanDefinitionParser parser = null;
        QName typeName = DOMTypeSupport.getXSIType((Element)element);
        if (typeName != null) {
            this.log.trace("Attempting to find parser for element of type: {}", (Object)typeName);
            parser = this.parsers.get(typeName);
        }
        QName elementName = null;
        if (parser == null) {
            elementName = QNameSupport.getNodeQName((Node)element);
            this.log.trace("Attempting to find parser with element name: {}", (Object)elementName);
            parser = this.parsers.get(elementName);
        }
        if (parser == null) {
            String msg = "Can not locate BeanDefinitionParser for element: " + elementName;
            if (typeName != null) {
                msg = msg + ", carrying xsi:type: " + typeName;
            }
            this.log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return parser;
    }

    protected BeanDefinitionDecorator findDecoratorForNode(Node node) {
        BeanDefinitionDecorator decorator = null;
        if (node instanceof Element) {
            decorator = this.decorators.get(DOMTypeSupport.getXSIType((Element)((Element)node)));
            if (decorator == null) {
                decorator = this.decorators.get(QNameSupport.getNodeQName((Node)node));
            }
        } else if (node instanceof Attr) {
            decorator = this.attributeDecorators.get(node.getLocalName());
        } else {
            throw new IllegalArgumentException("Can not decorate based on Nodes of type [" + node.getClass().getName() + "]");
        }
        if (decorator == null) {
            throw new IllegalArgumentException("Can not locate BeanDefinitionDecorator for  [" + node.getLocalName() + "]");
        }
        return decorator;
    }

    protected void registerBeanDefinitionParser(QName elementNameOrType, BeanDefinitionParser parser) {
        this.parsers.put(elementNameOrType, parser);
    }

    protected void registerBeanDefinitionDecorator(QName elementNameOrType, BeanDefinitionDecorator decorator) {
        this.decorators.put(elementNameOrType, decorator);
    }

    protected void registerBeanDefinitionDecoratorForAttribute(QName attributeName, BeanDefinitionDecorator decorator) {
        this.attributeDecorators.put(attributeName, decorator);
    }
}

