/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.context;

import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class FileSystemXmlWebApplicationContext
extends XmlWebApplicationContext {
    protected Resource getResourceByPath(String path) {
        FileSystemResource r = new FileSystemResource(path);
        if (r.exists()) {
            return r;
        }
        return super.getResourceByPath(path);
    }

    public Resource getResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        if (location.startsWith("classpath*:")) {
            return new ClassPathResource(location.substring("classpath*:".length()), this.getClassLoader());
        }
        return super.getResource(location);
    }
}

