/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SQLQuery
extends StyleElement {
    Expression connection;
    Expression column;
    Expression table;
    Expression where;
    String rowTag;
    String colTag;
    boolean disable = false;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string;
        String string2 = this.attributeList.getValue("column");
        if (string2 == null) {
            this.reportAbsence("column");
        }
        this.column = this.makeAttributeValueTemplate(string2);
        String string3 = this.attributeList.getValue("table");
        if (string3 == null) {
            this.reportAbsence("table");
        }
        this.table = this.makeAttributeValueTemplate(string3);
        String string4 = this.attributeList.getValue("where");
        this.where = string4 == null ? StringValue.EMPTY_STRING : this.makeAttributeValueTemplate(string4);
        String string5 = this.attributeList.getValue("connection");
        if (string5 == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(string5);
        }
        this.rowTag = this.attributeList.getValue("row-tag");
        if (this.rowTag == null) {
            this.rowTag = "row";
        }
        if (this.rowTag.indexOf(58) >= 0) {
            this.compileError("rowTag must not contain a colon");
        }
        this.colTag = this.attributeList.getValue("column-tag");
        if (this.colTag == null) {
            this.colTag = "col";
        }
        if (this.colTag.indexOf(58) >= 0) {
            this.compileError("colTag must not contain a colon");
        }
        if ((string = this.attributeList.getValue("disable-output-escaping")) != null) {
            if (string.equals("yes")) {
                this.disable = true;
            } else if (string.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.column = this.typeCheck("column", this.column);
        this.table = this.typeCheck("table", this.table);
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Instruction compile() throws TransformerConfigurationException {
        QueryInstruction queryInstruction = new QueryInstruction(this.connection, this.column, this.table, this.where, this.rowTag, this.colTag, this.disable);
        return queryInstruction;
    }

    private static class QueryInstruction
    extends Instruction {
        Expression connectExpr;
        Expression column;
        Expression table;
        Expression where;
        String rowTag;
        String colTag;
        int options;

        public QueryInstruction(Expression expression, Expression expression2, Expression expression3, Expression expression4, String string, String string2, boolean bl) {
            this.connectExpr = expression;
            this.column = expression2;
            this.table = expression3;
            this.where = expression4;
            this.rowTag = string;
            this.colTag = string2;
            this.options = bl ? 1 : 0;
        }

        public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
            instructionDetails.setInstructionName("query");
            instructionDetails.setProperty("instruction-namespace", (Object)"java:/net.sf.saxon.sql.SQLElementFactory");
        }

        public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
            Controller controller = xPathContext.getController();
            Item item = this.connectExpr.evaluateItem(xPathContext);
            if (!(item instanceof ObjectValue) || !(((ObjectValue)item).getObject() instanceof Connection)) {
                throw new TransformerException("Value of connection expression is not a JDBC Connection");
            }
            Connection connection = (Connection)((ObjectValue)item).getObject();
            String string = this.column.evaluateAsString(xPathContext);
            String string2 = this.table.evaluateAsString(xPathContext);
            String string3 = this.where.evaluateAsString(xPathContext);
            NamePool namePool = controller.getNamePool();
            int n = namePool.allocate("", "", this.rowTag);
            int n2 = namePool.allocate("", "", this.colTag);
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT " + string + " FROM " + string2);
                if (string3 != "") {
                    stringBuffer.append(" WHERE " + string3);
                }
                PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
                controller.setUserData((Object)this, "sql:statement", (Object)preparedStatement);
                ResultSet resultSet = preparedStatement.executeQuery();
                SequenceReceiver sequenceReceiver = controller.getReceiver();
                String string4 = "";
                int n3 = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    sequenceReceiver.startElement(n, 0, 0);
                    int n4 = 1;
                    while (n4 <= n3) {
                        string4 = resultSet.getString(n4);
                        sequenceReceiver.startElement(n2, 0, 0);
                        if (string4 != null) {
                            sequenceReceiver.characters((CharSequence)string4, this.options);
                        }
                        sequenceReceiver.endElement();
                        ++n4;
                    }
                    sequenceReceiver.endElement();
                }
                resultSet.close();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException sQLException) {
                throw new TransformerException("(SQL) " + sQLException.getMessage());
            }
            return null;
        }
    }
}

