/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sql.SQLInsert;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class SQLColumn
extends XSLGeneralVariable {
    public boolean isInstruction() {
        return false;
    }

    public boolean mayContainTemplateBody() {
        return false;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        this.getVariableFingerprint();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            String string3 = attributeCollection.getLocalName(n);
            if (string3.equals("name")) {
                string2 = attributeCollection.getValue(n).trim();
            } else if (string3.equals("select")) {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(attributeCollection.getNameCode(n));
            }
            ++n;
        }
        if (string2 == null) {
            this.reportAbsence("name");
        } else if (!Name.isQName(string2)) {
            this.compileError("Column name must be a valid QName");
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        if (!(this.getParentNode() instanceof SQLInsert)) {
            this.compileError("parent node must be sql:insert");
        }
        this.select = this.typeCheck("select", this.select);
        try {
            RoleLocator roleLocator = new RoleLocator(4, "sql:column/select", 0);
            this.select = TypeChecker.staticTypeCheck((Expression)this.select, (SequenceType)SequenceType.SINGLE_ATOMIC, (boolean)false, (RoleLocator)roleLocator);
        }
        catch (XPathException xPathException) {
            this.compileError((TransformerException)((Object)xPathException));
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        ColumnInstruction columnInstruction = new ColumnInstruction();
        this.initializeInstruction(columnInstruction);
        return columnInstruction;
    }

    public String getColumnName() {
        return Navigator.getAttributeValue((NodeInfo)this, (String)"", (String)"name");
    }

    protected static class ColumnInstruction
    extends GeneralVariable {
        public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
            instructionDetails.setInstructionName("column");
            instructionDetails.setProperty("instruction-namespace", (Object)"java:/net.sf.saxon.sql.SQLElementFactory");
        }

        public TailCall processLeavingTail(XPathContext xPathContext) {
            return null;
        }
    }
}

