/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.support;

import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openas2.OpenAS2Exception;
import org.openas2.support.FileMonitor;
import org.openas2.support.FileMonitorListener;

public abstract class FileMonitorAdapter
implements FileMonitorListener {
    public static final int MINIMAL_SCHEDULE_INTERVAL = 1;

    public void scheduleIfNeed(ScheduledExecutorService executor, File file, int refreshInterval, TimeUnit unit) {
        if (refreshInterval >= 1) {
            executor.scheduleAtFixedRate(new FileMonitor(file, this), refreshInterval, refreshInterval, unit);
        }
    }

    @Override
    public void onFileEvent(File file, int eventID) {
        switch (eventID) {
            case 1: {
                try {
                    this.onConfigFileChanged();
                    break;
                }
                catch (OpenAS2Exception oae) {
                    oae.terminate();
                }
            }
        }
    }

    public abstract void onConfigFileChanged() throws OpenAS2Exception;
}

