/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.storage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.DispositionException;
import org.openas2.OpenAS2Exception;
import org.openas2.WrappedException;
import org.openas2.message.Message;
import org.openas2.params.CompositeParameters;
import org.openas2.params.DateParameters;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.MessageParameters;
import org.openas2.params.ParameterParser;
import org.openas2.params.RandomParameters;
import org.openas2.processor.storage.BaseStorageModule;
import org.openas2.util.DispositionType;

public class MessageFileModule
extends BaseStorageModule {
    public static final String PARAM_HEADER = "header";
    private Log logger = LogFactory.getLog((String)MessageFileModule.class.getSimpleName());

    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        try {
            File msgFile = this.getFile(msg, this.getParameter("filename", true), action);
            InputStream in = msg.getData().getInputStream();
            this.store(msgFile, in);
            this.logger.info((Object)("stored message to " + msgFile.getAbsolutePath() + msg.getLogMsgID()));
        }
        catch (Exception e) {
            throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "Error storing transaction"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message.  An error occured while storing the data to the file system.", e);
        }
        String headerFilename = this.getParameter(PARAM_HEADER, false);
        if (headerFilename != null) {
            try {
                File headerFile = this.getFile(msg, headerFilename, action);
                InputStream in = this.getHeaderStream(msg);
                this.store(headerFile, in);
                this.logger.info((Object)("stored headers to " + headerFile.getAbsolutePath() + msg.getLogMsgID()));
            }
            catch (IOException ioe) {
                throw new WrappedException(ioe);
            }
        }
    }

    @Override
    protected String getModuleAction() {
        return "store";
    }

    @Override
    protected String getFilename(Message msg, String fileParam, String action) throws InvalidParameterException {
        CompositeParameters compParams = new CompositeParameters(false).add("date", new DateParameters()).add("msg", new MessageParameters(msg)).add("rand", new RandomParameters());
        return ParameterParser.parse(fileParam, compParams);
    }

    protected InputStream getHeaderStream(Message msg) throws IOException {
        StringBuffer headerBuf = new StringBuffer();
        headerBuf.append("Headers:" + System.getProperty("line.separator"));
        Enumeration headers = msg.getHeaders().getAllHeaderLines();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            headerBuf.append(header).append(System.getProperty("line.separator"));
        }
        headerBuf.append(System.getProperty("line.separator"));
        headerBuf.append("Attributes:" + System.getProperty("line.separator"));
        for (Map.Entry<String, String> attrEntry : msg.getAttributes().entrySet()) {
            headerBuf.append(attrEntry.getKey()).append(": ");
            headerBuf.append(attrEntry.getValue()).append(System.getProperty("line.separator"));
        }
        return new ByteArrayInputStream(headerBuf.toString().getBytes());
    }
}

