/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.receiver;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.params.InvalidParameterException;
import org.openas2.processor.receiver.MessageBuilderModule;

public abstract class PollingModule
extends MessageBuilderModule {
    private static final String PARAM_POLLING_INTERVAL = "interval";
    private Timer timer;
    private boolean busy;

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
        this.getParameter(PARAM_POLLING_INTERVAL, true);
    }

    private int getInterval() throws InvalidParameterException {
        return this.getParameterInt(PARAM_POLLING_INTERVAL, true);
    }

    public abstract void poll();

    @Override
    public void doStart() throws OpenAS2Exception {
        this.timer = new Timer(this.getName(), false);
        this.timer.scheduleAtFixedRate((TimerTask)new PollTask(), 0L, (long)(this.getInterval() * 1000));
    }

    @Override
    public void doStop() throws OpenAS2Exception {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private boolean isBusy() {
        return this.busy;
    }

    private void setBusy(boolean b) {
        this.busy = b;
    }

    private class PollTask
    extends TimerTask {
        private PollTask() {
        }

        @Override
        public void run() {
            if (!PollingModule.this.isBusy()) {
                PollingModule.this.setBusy(true);
                PollingModule.this.poll();
                PollingModule.this.setBusy(false);
            } else {
                System.out.println("Miss tick");
            }
        }
    }
}

