/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.receiver;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.openas2.DispositionException;
import org.openas2.OpenAS2Exception;
import org.openas2.WrappedException;
import org.openas2.cert.CertificateFactory;
import org.openas2.lib.helper.ICryptoHelper;
import org.openas2.lib.util.MimeUtil;
import org.openas2.logging.Log;
import org.openas2.message.AS2Message;
import org.openas2.message.MessageMDN;
import org.openas2.processor.receiver.AS2ReceiverModule;
import org.openas2.processor.receiver.NetModule;
import org.openas2.processor.receiver.NetModuleHandler;
import org.openas2.util.AS2Util;
import org.openas2.util.DispositionOptions;
import org.openas2.util.DispositionType;
import org.openas2.util.HTTPUtil;
import org.openas2.util.Properties;

public class AS2ReceiverHandler
implements NetModuleHandler {
    private AS2ReceiverModule module;
    private boolean removeHeaderFolding;
    private org.apache.commons.logging.Log logger = LogFactory.getLog((String)AS2ReceiverHandler.class.getSimpleName());

    public AS2ReceiverHandler(AS2ReceiverModule module) {
        this.module = module;
        this.removeHeaderFolding = "true".equals(Properties.getProperty("remove_http_header_folding", "true"));
    }

    public String getClientInfo(Socket s) {
        return " " + s.getInetAddress().getHostAddress() + " " + Integer.toString(s.getPort());
    }

    public AS2ReceiverModule getModule() {
        return this.module;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handle(NetModule owner, Socket s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[CATCHBLOCK]], but top level block is 16[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected AS2Message createMessage(Socket s) {
        AS2Message msg = new AS2Message();
        msg.setAttribute("source_ip", s.getInetAddress().toString());
        msg.setAttribute("source_port", Integer.toString(s.getPort()));
        msg.setAttribute("destination_ip", s.getLocalAddress().toString());
        msg.setAttribute("destination_port", Integer.toString(s.getLocalPort()));
        return msg;
    }

    protected String decryptAndVerify(AS2Message msg) throws OpenAS2Exception {
        DispositionOptions dispOptions;
        ICryptoHelper ch;
        CertificateFactory certFx = this.getModule().getSession().getCertificateFactory();
        String mic = null;
        try {
            ch = AS2Util.getCryptoHelper();
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        boolean isDecompressed = false;
        try {
            if (ch.isEncrypted(msg.getData())) {
                msg.setRxdMsgWasEncrypted(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("decrypting :::" + msg.getLogMsgID()));
                }
                X509Certificate receiverCert = certFx.getCertificate(msg, "receiver");
                PrivateKey receiverKey = certFx.getPrivateKey(msg, receiverCert);
                msg.setData(AS2Util.getCryptoHelper().decrypt(msg.getData(), receiverCert, receiverKey));
                if (this.logger.isTraceEnabled() && "true".equalsIgnoreCase(System.getProperty("logRxdMsgMimeBodyParts", "false"))) {
                    this.logger.trace((Object)("Received MimeBodyPart for inbound message after decryption: " + msg.getLogMsgID() + "\n" + MimeUtil.toString(msg.getData(), true)));
                }
            }
        }
        catch (Exception e) {
            msg.setLogMsg("Error extracting received message: " + e.getCause());
            this.logger.error((Object)msg, (Throwable)e);
            throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "decryption-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decrypting the content.", e);
        }
        try {
            if (ch.isCompressed(msg.getData())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Decompressing received message before checking signature...");
                }
                AS2Util.getCryptoHelper().decompress(msg);
                isDecompressed = true;
                if (this.logger.isTraceEnabled() && "true".equalsIgnoreCase(System.getProperty("logRxdMsgMimeBodyParts", "false"))) {
                    this.logger.trace((Object)("Received MimeBodyPart for inbound message after decompression: " + msg.getLogMsgID() + "\n" + MimeUtil.toString(msg.getData(), true)));
                }
            }
        }
        catch (Exception e1) {
            msg.setLogMsg("Error decompressing received message: " + e1.getCause());
            this.logger.error((Object)msg, (Throwable)e1);
            throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "decompresion-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.", e1);
        }
        try {
            if (ch.isSigned(msg.getData())) {
                msg.setRxdMsgWasSigned(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("verifying signature" + msg.getLogMsgID()));
                }
                X509Certificate senderCert = certFx.getCertificate(msg, "sender");
                msg.setData(AS2Util.getCryptoHelper().verifySignature(msg.getData(), senderCert));
                if (this.logger.isTraceEnabled() && "true".equalsIgnoreCase(System.getProperty("logRxdMsgMimeBodyParts", "false"))) {
                    this.logger.trace((Object)("Received MimeBodyPart for inbound message after signature verification: " + msg.getLogMsgID() + "\n" + MimeUtil.toString(msg.getData(), true)));
                }
            }
        }
        catch (Exception e) {
            msg.setLogMsg("Error decrypting received message: " + Log.getExceptionMsg(e));
            this.logger.error((Object)msg, (Throwable)e);
            throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "integrity-check-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. Authentication of the originator of the message failed.", e);
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("SMIME Decrypted Content-Disposition: " + msg.getContentDisposition() + "\n      Content-Type received: " + msg.getContentType() + "\n      HEADERS after decryption: " + msg.getData().getAllHeaders() + "\n      Content-Disposition in MSG getData() MIMEPART after decryption: " + msg.getData().getContentType()));
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
        if ((dispOptions = new DispositionOptions(msg.getHeader("Disposition-Notification-Options"))).getMicalg() != null) {
            try {
                mic = ch.calculateMIC(msg.getData(), dispOptions.getMicalg(), msg.isRxdMsgWasSigned() || msg.isRxdMsgWasEncrypted(), msg.getPartnership().isPreventCanonicalization());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Prevent Canonicalization: " + msg.getPartnership().isPreventCanonicalization() + " ::: MIC calc on rxd msg: " + mic));
                }
                if (this.logger.isTraceEnabled()) {
                    String tmic = ch.calculateMIC(msg.getData(), dispOptions.getMicalg(), msg.isRxdMsgWasSigned() || msg.isRxdMsgWasEncrypted(), !msg.getPartnership().isPreventCanonicalization());
                    this.logger.trace((Object)("MIC with forced reversed prevent canocalization: " + tmic + msg.getLogMsgID()));
                    tmic = ch.calculateMIC(msg.getData(), dispOptions.getMicalg(), false, msg.getPartnership().isPreventCanonicalization());
                    this.logger.trace((Object)("MIC with forced exclude headers flag: " + tmic + msg.getLogMsgID()));
                }
            }
            catch (Exception e) {
                msg.setLogMsg("Error calculating MIC on received message: " + e.getCause());
                this.logger.error((Object)msg, (Throwable)e);
                throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "unexpected-processing-error"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. Calculation of the MIC for the message failed.", e);
            }
        }
        try {
            if (ch.isCompressed(msg.getData())) {
                if (isDecompressed) {
                    throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "decompression-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.", new Exception("Message has already been decompressed. Per RFC5402 it cannot occur twice."));
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Decompressing received message after decryption...");
                }
                AS2Util.getCryptoHelper().decompress(msg);
            }
        }
        catch (Exception e) {
            msg.setLogMsg("Unexepcted error checking for compressed message after signing");
            this.logger.error((Object)msg, (Throwable)e);
            throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "decompression-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.", new Exception("Unexpected error occurred checking for compressed message: " + e.getMessage()));
        }
        return mic;
    }

    protected void sendMDNResponse(AS2Message msg, BufferedOutputStream out, DispositionType disposition, String mic, String text) {
        boolean mdnBlocked = false;
        boolean bl = mdnBlocked = msg.getPartnership().getAttribute("blockerrormdn") != null;
        if (!mdnBlocked) {
            try {
                MessageMDN mdn = AS2Util.createMDN(this.getModule().getSession(), msg, mic, disposition, text);
                if (msg.isRequestingAsynchMDN()) {
                    HTTPUtil.sendHTTPResponse(out, 200, false);
                    out.write("Content-Length: 0\r\n\r\n".getBytes());
                    out.flush();
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("setup to send asynch MDN [" + disposition.toString() + "]" + msg.getLogMsgID()));
                    }
                    return;
                }
                HTTPUtil.sendHTTPResponse(out, 200, true);
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                MimeBodyPart part = mdn.getData();
                IOUtils.copy((InputStream)part.getInputStream(), (OutputStream)data);
                mdn.setHeader("Content-Length", Integer.toString(data.size()));
                Enumeration headers = mdn.getHeaders().getAllHeaderLines();
                StringBuffer saveHeaders = new StringBuffer();
                while (headers.hasMoreElements()) {
                    String header = (String)headers.nextElement();
                    saveHeaders = saveHeaders.append(";;").append(header);
                    if (this.removeHeaderFolding) {
                        header = header.replaceAll("\r\n[ \t]*", " ");
                    }
                    out.write((header + "\r\n").getBytes());
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("MDN HEADERS SENT: " + saveHeaders + msg.getLogMsgID()));
                }
                out.write("\r\n".getBytes());
                data.writeTo(out);
                out.flush();
                this.getModule().getSession().getProcessor().handle("storemdn", msg, null);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("sent MDN [" + disposition.toString() + "]" + msg.getLogMsgID()));
                }
            }
            catch (Exception e) {
                WrappedException we = new WrappedException("Error sending MDN", e);
                we.addSource("message", msg);
                we.terminate();
                msg.setLogMsg("Unexpected error occurred sending MDN: " + Log.getExceptionMsg(e));
                this.logger.error((Object)msg, (Throwable)e);
            }
        }
    }
}

