/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.BaseComponent;
import org.openas2.OpenAS2Exception;
import org.openas2.message.Message;
import org.openas2.processor.ActiveModule;
import org.openas2.processor.NoModuleException;
import org.openas2.processor.Processor;
import org.openas2.processor.ProcessorException;
import org.openas2.processor.ProcessorModule;

public class DefaultProcessor
extends BaseComponent
implements Processor {
    private List<ProcessorModule> modules = new ArrayList<ProcessorModule>();
    private Log logger = LogFactory.getLog((String)DefaultProcessor.class.getSimpleName());

    @Override
    public List<ActiveModule> getActiveModules() {
        ArrayList<ActiveModule> activeMods = new ArrayList<ActiveModule>();
        for (ProcessorModule procMod : this.getModules()) {
            if (!(procMod instanceof ActiveModule)) continue;
            activeMods.add((ActiveModule)procMod);
        }
        return activeMods;
    }

    @Override
    public List<ProcessorModule> getModules() {
        return this.modules;
    }

    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        Iterator<ProcessorModule> moduleIt = this.getModules().iterator();
        ProcessorException pex = null;
        boolean moduleFound = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processor searching for module handler for action: " + action));
        }
        while (moduleIt.hasNext()) {
            ProcessorModule module = moduleIt.next();
            if (!module.canHandle(action, msg, options)) continue;
            try {
                moduleFound = true;
                module.handle(action, msg, options);
            }
            catch (OpenAS2Exception oae) {
                if (pex != null) continue;
                pex = new ProcessorException(this);
                pex.getCauses().add(oae);
            }
        }
        if (pex != null) {
            throw pex;
        }
        if (!moduleFound) {
            if ("true".equalsIgnoreCase((String)options.get("OPTIONAL_MODULE"))) {
                return;
            }
            msg.setLogMsg("No handler found for action: " + action);
            this.logger.error((Object)msg);
            throw new NoModuleException(action, msg, options);
        }
    }

    @Override
    public void startActiveModules() throws OpenAS2Exception {
        List<ActiveModule> activeModules = this.getActiveModules();
        for (ActiveModule activeModule : activeModules) {
            try {
                activeModule.start();
                this.logger.info((Object)(ClassUtils.getSimpleName(activeModule.getClass()) + " started."));
            }
            catch (OpenAS2Exception e) {
                e.terminate();
                throw e;
            }
        }
        this.logger.info((Object)(activeModules.size() + " active module(s) started."));
    }

    @Override
    public void stopActiveModules() {
        List<ActiveModule> activeModules = this.getActiveModules();
        int stopCnt = 0;
        for (ActiveModule activeModule : activeModules) {
            try {
                if (!activeModule.isRunning()) continue;
                activeModule.stop();
                ++stopCnt;
                this.logger.info((Object)(ClassUtils.getSimpleName(activeModule.getClass()) + " stopped."));
            }
            catch (OpenAS2Exception e) {
                e.terminate();
            }
        }
        if (this.logger.isInfoEnabled()) {
            if (stopCnt > 0) {
                this.logger.info((Object)(stopCnt + " active module(s) stopped."));
            } else {
                this.logger.info((Object)"No active module(s) are running.");
            }
        }
    }

    @Override
    public void destroy() throws Exception {
        this.stopActiveModules();
    }
}

