/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.pgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;

public class PGPEncryptionUtil {
    private static final int BUFFER_SIZE = 16364;
    private int payloadEncryptAlg = 9;
    private final ArmoredOutputStream armoredOutputStream = null;
    private OutputStream encryptedOut = null;
    private OutputStream compressedOut = null;
    private OutputStream literalOut;
    private boolean supportPGP2_6 = false;
    private boolean isCompressData = true;
    private boolean isArmor = true;

    public PGPEncryptionUtil(PGPPublicKey key, String payloadFilename, OutputStream out) throws PGPException, NoSuchProviderException, IOException {
        BcPGPDataEncryptorBuilder builder = new BcPGPDataEncryptorBuilder(this.payloadEncryptAlg);
        builder.setSecureRandom(new SecureRandom());
        PGPEncryptedDataGenerator encryptGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)builder, this.supportPGP2_6);
        encryptGen.addMethod((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(key));
        byte[] buffer = new byte[16364];
        this.encryptedOut = encryptGen.open((OutputStream)(this.isArmor ? new ArmoredOutputStream(out) : out), buffer);
        PGPLiteralDataGenerator literalGen = new PGPLiteralDataGenerator();
        if (this.isCompressData) {
            PGPCompressedDataGenerator compressor = new PGPCompressedDataGenerator(1);
            this.compressedOut = compressor.open(this.encryptedOut);
            this.literalOut = literalGen.open(this.compressedOut, 'u', payloadFilename, new Date(), new byte[16364]);
        } else {
            this.literalOut = literalGen.open(this.encryptedOut, 'u', payloadFilename, new Date(), new byte[16364]);
        }
    }

    public OutputStream getPayloadOutputStream() {
        return this.literalOut;
    }

    public void close() throws IOException {
        if (this.literalOut != null) {
            this.literalOut.close();
        }
        if (this.compressedOut != null) {
            this.compressedOut.close();
        }
        if (this.encryptedOut != null) {
            this.encryptedOut.close();
        }
        if (this.armoredOutputStream != null) {
            this.armoredOutputStream.close();
        }
    }

    public boolean isCompressData() {
        return this.isCompressData;
    }

    public void setCompressData(boolean isCompressData) {
        this.isCompressData = isCompressData;
    }

    public boolean isSupportPGP2_6() {
        return this.supportPGP2_6;
    }

    public void setSupportPGP2_6(boolean supportPGP2_6) {
        this.supportPGP2_6 = supportPGP2_6;
    }

    public int getPayloadEncryptAlg() {
        return this.payloadEncryptAlg;
    }

    public void setPayloadEncryptAlg(int payloadEncryptAlg) {
        this.payloadEncryptAlg = payloadEncryptAlg;
    }

    public boolean isArmor() {
        return this.isArmor;
    }

    public void setArmor(boolean isArmor) {
        this.isArmor = isArmor;
    }
}

