/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.params;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openas2.WrappedException;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.ParameterParser;

public class ExceptionParameters
extends ParameterParser {
    public static final String KEY_NAME = "name";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_TRACE = "trace";
    public static final String KEY_TERMINATED = "terminated";
    private Throwable target;
    private boolean terminated;

    public ExceptionParameters(Throwable target, boolean terminated) {
        this.target = target;
        this.terminated = terminated;
    }

    @Override
    public void setParameter(String key, String value) throws InvalidParameterException {
        if (key == null) {
            throw new InvalidParameterException("Invalid key", this, key, value);
        }
        if (key.equals(KEY_NAME) || key.equals(KEY_MESSAGE) || key.equals(KEY_TRACE) || key.equals(KEY_TERMINATED)) {
            throw new InvalidParameterException("Parameter is read-only", this, key, value);
        }
        throw new InvalidParameterException("Invalid key", this, key, value);
    }

    @Override
    public String getParameter(String key) throws InvalidParameterException {
        Throwable target;
        if (key == null) {
            throw new InvalidParameterException("Invalid key", this, key, null);
        }
        Throwable unwrappedTarget = target = this.getTarget();
        if (target instanceof WrappedException && (unwrappedTarget = ((WrappedException)target).getSource()) == null) {
            unwrappedTarget = target;
        }
        if (key.equals(KEY_NAME)) {
            return unwrappedTarget.getClass().getName();
        }
        if (key.equals(KEY_MESSAGE)) {
            return unwrappedTarget.getMessage();
        }
        if (key.equals(KEY_TRACE)) {
            return ExceptionUtils.getStackTrace((Throwable)target);
        }
        if (key.equals(KEY_TERMINATED)) {
            if (this.isTerminated()) {
                return KEY_TERMINATED;
            }
            return "";
        }
        throw new InvalidParameterException("Invalid key", this, key, null);
    }

    public void setTarget(Exception target) {
        this.target = target;
    }

    public Throwable getTarget() {
        return this.target;
    }

    public boolean isTerminated() {
        return this.terminated;
    }
}

