/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.util.javamail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class ByteArrayDataSource
implements DataSource {
    String contentType;
    String name;
    byte[] bytes;

    public ByteArrayDataSource(byte[] bytes, String contentType, String name) {
        this.bytes = bytes;
        this.contentType = contentType == null ? "application/octet-stream" : contentType;
        this.name = name;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes, 0, this.bytes.length);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        return new WrappedOutputStream(this);
    }

    private class WrappedOutputStream
    extends ByteArrayOutputStream {
        private ByteArrayDataSource owner;

        public WrappedOutputStream(ByteArrayDataSource owner) {
            this.owner = owner;
        }

        @Override
        public void close() {
            if (this.getOwner() != null) {
                this.getOwner().setBytes(this.toByteArray());
            }
        }

        public ByteArrayDataSource getOwner() {
            return this.owner;
        }
    }
}

