/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.message;

import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.openas2.lib.message.AS2MDNData;
import org.openas2.lib.message.EDIINTMessageMDN;
import org.openas2.lib.message.MDNData;
import org.openas2.util.Properties;

public class AS2MessageMDN
extends EDIINTMessageMDN {
    private AS2MDNData mdnData;

    public AS2MessageMDN() {
    }

    public AS2MessageMDN(MimeBodyPart data, String contentType) throws MessagingException {
        super(data, contentType);
    }

    public AS2MessageMDN(InputStream in) throws IOException, MessagingException {
        super(in);
    }

    @Override
    public String getSenderIDHeader() {
        return "AS2-From";
    }

    @Override
    public String getReceiverIDHeader() {
        return "AS2-To";
    }

    @Override
    public MDNData getMDNData() {
        if (this.mdnData == null) {
            this.mdnData = new AS2MDNData(this);
        }
        return this.mdnData;
    }

    public void setAS2From(String from) {
        this.setHeader("AS2-From", from);
    }

    public String getAS2From() {
        return this.getHeader("AS2-From");
    }

    public void setAS2To(String to) {
        this.setHeader("AS2-To", to);
    }

    public String getAS2To() {
        return this.getHeader("AS2-To");
    }

    public void setAS2Version(String version) {
        this.setHeader("AS2-Version", version);
    }

    public String getAS2Version() {
        return this.getHeader("AS2-Version");
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        this.setAS2Version(Properties.getProperty(Properties.APP_VERSION_PROP, ""));
        this.setServer(Properties.getProperty(Properties.APP_TITLE_PROP, "OpenAS2 Server"));
    }

    public void setServer(String server) {
        this.setHeader("Server", server);
    }

    public String getServer() {
        return this.getHeader("Server");
    }
}

