/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ClassUtils;
import org.openas2.Component;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.cmd.Command;
import org.openas2.cmd.CommandRegistry;
import org.openas2.cmd.processor.CommandProcessor;
import org.openas2.schedule.HasSchedule;

public abstract class BaseCommandProcessor
implements CommandProcessor,
Component,
HasSchedule {
    private static final Void VOID = null;
    private List<Command> commands = new ArrayList<Command>();
    private Session session;
    private Map<String, String> parameters;
    private boolean running = true;

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    public String getName() {
        return ClassUtils.getSimpleName(this.getClass());
    }

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        this.session = session;
        this.parameters = parameters;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Nullable
    Command getCommand(String name) {
        for (Command command : this.getCommands()) {
            Command currentCmd = command;
            if (!currentCmd.getName().equals(name)) continue;
            return currentCmd;
        }
        return null;
    }

    @Override
    public abstract void processCommand() throws Exception;

    @Override
    public void addCommands(CommandRegistry reg) {
        List<Command> regCmds = reg.getCommands();
        if (regCmds.size() > 0) {
            this.commands.addAll(regCmds);
        }
    }

    @Override
    public void terminate() throws Exception {
        this.running = false;
        this.getSession().stop();
    }

    @Override
    public void destroy() throws Exception {
        this.running = false;
    }

    @Override
    public void schedule(ScheduledExecutorService executor) throws OpenAS2Exception {
        executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (BaseCommandProcessor.this.running) {
                    BaseCommandProcessor.this.processCommand();
                }
                return VOID;
            }
        });
    }
}

