/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cert;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.cert.AliasedCertificateFactory;
import org.openas2.cert.BaseCertificateFactory;
import org.openas2.cert.CertificateExistsException;
import org.openas2.cert.CertificateNotFoundException;
import org.openas2.cert.KeyNotFoundException;
import org.openas2.cert.KeyStoreCertificateFactory;
import org.openas2.cert.StorableCertificateFactory;
import org.openas2.message.Message;
import org.openas2.message.MessageMDN;
import org.openas2.params.InvalidParameterException;
import org.openas2.partner.Partnership;
import org.openas2.schedule.HasSchedule;
import org.openas2.support.FileMonitorAdapter;
import org.openas2.util.AS2Util;

public class PKCS12CertificateFactory
extends BaseCertificateFactory
implements AliasedCertificateFactory,
KeyStoreCertificateFactory,
StorableCertificateFactory,
HasSchedule {
    public static final String PARAM_FILENAME = "filename";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_INTERVAL = "interval";
    private KeyStore keyStore;
    private Log logger = LogFactory.getLog((String)PKCS12CertificateFactory.class.getSimpleName());

    public String getAlias(Partnership partnership, String partnershipType) throws OpenAS2Exception {
        String alias = null;
        if (partnershipType == "receiver") {
            alias = partnership.getReceiverID("x509_alias");
        } else if (partnershipType == "sender") {
            alias = partnership.getSenderID("x509_alias");
        }
        if (alias == null) {
            throw new CertificateNotFoundException(partnershipType, null);
        }
        return alias;
    }

    @Override
    public X509Certificate getCertificate(String alias) throws OpenAS2Exception {
        try {
            KeyStore ks = this.getKeyStore();
            X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
            if (cert == null) {
                throw new CertificateNotFoundException(null, alias);
            }
            return cert;
        }
        catch (KeyStoreException kse) {
            throw new WrappedException(kse);
        }
    }

    @Override
    public X509Certificate getCertificate(Message msg, String partnershipType) throws OpenAS2Exception {
        try {
            return this.getCertificate(this.getAlias(msg.getPartnership(), partnershipType));
        }
        catch (CertificateNotFoundException cnfe) {
            cnfe.setPartnershipType(partnershipType);
            throw cnfe;
        }
    }

    @Override
    public X509Certificate getCertificate(MessageMDN mdn, String partnershipType) throws OpenAS2Exception {
        try {
            return this.getCertificate(this.getAlias(mdn.getPartnership(), partnershipType));
        }
        catch (CertificateNotFoundException cnfe) {
            cnfe.setPartnershipType(partnershipType);
            throw cnfe;
        }
    }

    @Override
    public Map<String, X509Certificate> getCertificates() throws OpenAS2Exception {
        KeyStore ks = this.getKeyStore();
        try {
            HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                String certAlias = e.nextElement();
                certs.put(certAlias, (X509Certificate)ks.getCertificate(certAlias));
            }
            return certs;
        }
        catch (GeneralSecurityException gse) {
            throw new WrappedException(gse);
        }
    }

    private int getRefreshInterval() throws InvalidParameterException {
        return this.getParameterInt(PARAM_INTERVAL, false);
    }

    @Override
    public String getFilename() throws InvalidParameterException {
        return this.getParameter(PARAM_FILENAME, true);
    }

    @Override
    public void setFilename(String filename) {
        this.getParameters().put(PARAM_FILENAME, filename);
    }

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public char[] getPassword() throws InvalidParameterException {
        return this.getParameter(PARAM_PASSWORD, true).toCharArray();
    }

    @Override
    public void setPassword(char[] password) {
        this.getParameters().put(PARAM_PASSWORD, new String(password));
    }

    private PrivateKey getPrivateKey(X509Certificate cert) throws OpenAS2Exception {
        KeyStore ks = this.getKeyStore();
        String alias = null;
        try {
            alias = ks.getCertificateAlias(cert);
            if (alias == null) {
                throw new KeyNotFoundException(cert, "-- alias null from getCertificateAlias(cert) call");
            }
            PrivateKey key = (PrivateKey)ks.getKey(alias, this.getPassword());
            if (key == null) {
                throw new KeyNotFoundException(cert, "-- key null from getKey(" + alias + ") call");
            }
            return key;
        }
        catch (GeneralSecurityException e) {
            throw new KeyNotFoundException(cert, alias, e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(Message msg, X509Certificate cert) throws OpenAS2Exception {
        return this.getPrivateKey(cert);
    }

    @Override
    public PrivateKey getPrivateKey(MessageMDN mdn, X509Certificate cert) throws OpenAS2Exception {
        return this.getPrivateKey(cert);
    }

    @Override
    public void addCertificate(String alias, X509Certificate cert, boolean overwrite) throws OpenAS2Exception {
        KeyStore ks = this.getKeyStore();
        try {
            if (ks.containsAlias(alias) && !overwrite) {
                throw new CertificateExistsException(alias);
            }
            ks.setCertificateEntry(alias, cert);
            this.save(this.getFilename(), this.getPassword());
        }
        catch (GeneralSecurityException gse) {
            throw new WrappedException(gse);
        }
    }

    @Override
    public void addPrivateKey(String alias, Key key, String password) throws OpenAS2Exception {
        KeyStore ks = this.getKeyStore();
        try {
            X509Certificate x509cert;
            if (!ks.containsAlias(alias)) {
                throw new CertificateNotFoundException(null, alias);
            }
            Certificate[] certChain = ks.getCertificateChain(alias);
            if (certChain == null && (x509cert = (X509Certificate)ks.getCertificate(alias)).getSubjectDN().equals(x509cert.getIssuerDN())) {
                certChain = new X509Certificate[]{x509cert, x509cert};
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Detected self-signed certificate and allowed import. Alias: " + alias));
                }
            }
            ks.setKeyEntry(alias, key, password.toCharArray(), certChain);
            this.save(this.getFilename(), this.getPassword());
        }
        catch (GeneralSecurityException gse) {
            throw new WrappedException(gse);
        }
    }

    @Override
    public void clearCertificates() throws OpenAS2Exception {
        KeyStore ks = this.getKeyStore();
        try {
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                ks.deleteEntry(aliases.nextElement());
            }
            this.save(this.getFilename(), this.getPassword());
        }
        catch (GeneralSecurityException gse) {
            throw new WrappedException(gse);
        }
    }

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
        String pwd = System.getProperty("org.openas2.cert.Password");
        if (pwd != null) {
            this.setPassword(pwd.toCharArray());
        }
        try {
            this.keyStore = AS2Util.getCryptoHelper().getKeyStore();
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        this.load();
    }

    @Override
    public void load(String filename, char[] password) throws OpenAS2Exception {
        try {
            FileInputStream fIn = new FileInputStream(filename);
            this.load(fIn, password);
            fIn.close();
        }
        catch (IOException ioe) {
            throw new WrappedException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(InputStream in, char[] password) throws OpenAS2Exception {
        try {
            KeyStore ks;
            KeyStore keyStore = ks = this.getKeyStore();
            synchronized (keyStore) {
                ks.load(in, password);
            }
        }
        catch (IOException ioe) {
            throw new WrappedException(ioe);
        }
        catch (GeneralSecurityException gse) {
            throw new WrappedException(gse);
        }
    }

    @Override
    public void load() throws OpenAS2Exception {
        this.load(this.getFilename(), this.getPassword());
    }

    @Override
    public void removeCertificate(X509Certificate cert) throws OpenAS2Exception {
        KeyStore ks = this.getKeyStore();
        try {
            String alias = ks.getCertificateAlias(cert);
            if (alias == null) {
                throw new CertificateNotFoundException(cert);
            }
            this.removeCertificate(alias);
        }
        catch (GeneralSecurityException gse) {
            throw new WrappedException(gse);
        }
    }

    @Override
    public void removeCertificate(String alias) throws OpenAS2Exception {
        KeyStore ks = this.getKeyStore();
        try {
            if (ks.getCertificate(alias) == null) {
                throw new CertificateNotFoundException(null, alias);
            }
            ks.deleteEntry(alias);
            this.save(this.getFilename(), this.getPassword());
        }
        catch (GeneralSecurityException gse) {
            throw new WrappedException(gse);
        }
    }

    @Override
    public void save() throws OpenAS2Exception {
        this.save(this.getFilename(), this.getPassword());
    }

    @Override
    public void save(String filename, char[] password) throws OpenAS2Exception {
        try {
            FileOutputStream fOut = new FileOutputStream(filename, false);
            this.save(fOut, password);
            fOut.close();
        }
        catch (IOException ioe) {
            throw new WrappedException(ioe);
        }
    }

    @Override
    public void save(OutputStream out, char[] password) throws OpenAS2Exception {
        try {
            this.getKeyStore().store(out, password);
        }
        catch (IOException ioe) {
            throw new WrappedException(ioe);
        }
        catch (GeneralSecurityException gse) {
            throw new WrappedException(gse);
        }
    }

    @Override
    public void schedule(ScheduledExecutorService executor) throws OpenAS2Exception {
        new FileMonitorAdapter(){

            @Override
            public void onConfigFileChanged() throws OpenAS2Exception {
                PKCS12CertificateFactory.this.load();
                PKCS12CertificateFactory.this.logger.info((Object)"- Certificates Reloaded -");
            }
        }.scheduleIfNeed(executor, new File(this.getFilename()), this.getRefreshInterval(), TimeUnit.SECONDS);
    }
}

