/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.app.partner;

import org.openas2.OpenAS2Exception;
import org.openas2.app.partner.AliasedPartnershipsCommand;
import org.openas2.cmd.CommandResult;
import org.openas2.partner.Partnership;
import org.openas2.partner.PartnershipFactory;

public class DeletePartnershipCommand
extends AliasedPartnershipsCommand {
    @Override
    public String getDefaultDescription() {
        return "Delete the partnership associated with an name.";
    }

    @Override
    public String getDefaultName() {
        return "delete";
    }

    @Override
    public String getDefaultUsage() {
        return "delete <name>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(PartnershipFactory partFx, Object[] params) throws OpenAS2Exception {
        if (params.length < 1) {
            return new CommandResult("INVALID PARAMETER COUNT", this.getUsage());
        }
        PartnershipFactory partnershipFactory = partFx;
        synchronized (partnershipFactory) {
            String name = params[0].toString();
            for (Partnership part : partFx.getPartnerships()) {
                if (!part.getName().equals(name)) continue;
                partFx.getPartnerships().remove(part);
                return new CommandResult("OK", "deleted " + name);
            }
            return new CommandResult("ERROR", "Unknown partnership name");
        }
    }
}

