/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.common;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;

public final class PensieveUtil {
    private PensieveUtil() {
    }

    public static TranslationUnit convertToTranslationUnit(LocaleId sourceLoc, LocaleId targetLoc, ITextUnit textUnit) {
        TranslationUnitVariant source = new TranslationUnitVariant(sourceLoc, textUnit.getSource().getFirstContent());
        TextContainer tc = textUnit.getTarget(targetLoc);
        TranslationUnitVariant target = new TranslationUnitVariant(targetLoc, tc == null ? null : tc.getFirstContent());
        TranslationUnit tu = new TranslationUnit(source, target);
        PensieveUtil.populateMetaDataFromProperties(textUnit, tu);
        return tu;
    }

    public static ITextUnit convertToTextUnit(TranslationUnit tu) {
        String tuid = (String)tu.getMetadata().get((Object)MetadataType.ID);
        TextUnit textUnit = new TextUnit(tuid);
        if (tuid != null) {
            textUnit.setName(tuid);
        }
        textUnit.setSourceContent(tu.getSource().getContent());
        textUnit.setTargetContent(tu.getTarget().getLanguage(), tu.getTarget().getContent());
        for (MetadataType type : tu.getMetadata().keySet()) {
            if (type == MetadataType.ID) continue;
            textUnit.setProperty(new Property(type.fieldName(), (String)tu.getMetadata().get((Object)type)));
        }
        return textUnit;
    }

    private static void populateMetaDataFromProperties(ITextUnit textUnit, TranslationUnit tu) {
        for (String key : textUnit.getPropertyNames()) {
            MetadataType mdt = MetadataType.findMetadataType(key);
            if (mdt == null) continue;
            tu.getMetadata().put(mdt, textUnit.getProperty(key).getValue());
        }
    }
}

