/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.wordcount.WordCounter;
import net.sf.okapi.steps.xliffsplitter.XliffWCSplitterParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XliffWCSplitter {
    private static final QName QNTRANSLATE = new QName("", "translate");
    private static final QName QNSTATE = new QName("", "state");
    private static final QName QNSTATEQUALIFIER = new QName("", "state-qualifier");
    private static final String CONTEXT_GROUP = "context-group";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final XMLInputFactory xif;
    private final XMLOutputFactory xof;
    private final XMLEventFactory evfact;
    private XliffWCSplitterParameters params;
    private String outputRoot;
    File partFile;
    private int count;
    private int partCount;
    private XMLEventReader reader = null;
    private XMLEventWriter writer = null;
    private LocaleId srcLoc;
    private StringBuilder content;
    private String state;
    private String stateQualifier;
    private boolean isTranslatable;
    private boolean splitASAP;
    private List<XMLEvent> events;
    private boolean storeEvents;
    private Stack<XMLEvent> stack;
    private Stack<Boolean> translate;
    private LinkedHashMap<String, Integer> files;

    public XliffWCSplitter(XliffWCSplitterParameters params) {
        this.params = params;
        this.xif = XMLInputFactory.newInstance();
        this.xof = XMLOutputFactory.newInstance();
        this.evfact = XMLEventFactory.newInstance();
        this.xif.setProperty("javax.xml.stream.supportDTD", false);
    }

    public Map<String, Integer> process(RawDocument rawDoc) {
        URI uri = rawDoc.getInputURI();
        if (uri == null) {
            throw new InvalidParameterException("This step does not support non-URI raw documents.");
        }
        String outRoot = uri.getPath();
        int p = outRoot.lastIndexOf(46);
        if (p != -1) {
            outRoot = outRoot.substring(0, p);
        }
        return this.process(rawDoc.getStream(), outRoot, rawDoc.getSourceLocale().toString());
    }

    public Map<String, Integer> process(InputStream inputStream, String outputRoot, String srcLang) {
        this.files = new LinkedHashMap();
        try {
            this.outputRoot = outputRoot;
            this.srcLoc = LocaleId.fromBCP47(srcLang);
            this.partCount = 0;
            this.events = new ArrayList<XMLEvent>();
            this.storeEvents = false;
            this.stack = new Stack();
            this.reader = this.xif.createXMLEventReader(inputStream);
            this.startPart();
            this.readAndwrite();
        }
        catch (IOException | XMLStreamException e) {
            this.logger.error(e.getMessage());
            throw new OkapiIOException(e);
        }
        finally {
            this.endPart();
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (XMLStreamException e) {
                    this.logger.error(e.getMessage());
                }
                this.reader = null;
            }
        }
        return this.files;
    }

    private void store(XMLEvent event) {
        if (!this.storeEvents) {
            return;
        }
        this.events.add(event);
    }

    private void startPart() throws XMLStreamException, IOException {
        this.splitASAP = false;
        this.count = 0;
        this.translate = new Stack();
        this.translate.push(true);
        this.partFile = new File(this.outputRoot + String.format("_PART%03d.xlf", ++this.partCount));
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.partFile), StandardCharsets.UTF_8);
        this.writer = this.xof.createXMLEventWriter(osw);
        osw.append('\ufeff');
    }

    private void endPart() {
        if (this.writer != null) {
            try {
                this.files.put(this.partFile.getName(), this.count);
                this.writer.flush();
                this.writer.close();
            }
            catch (XMLStreamException e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    private void split() throws XMLStreamException, IOException {
        int i;
        boolean inContextGroup = false;
        for (i = this.stack.size() - 1; i >= 0; --i) {
            XMLEvent event = (XMLEvent)this.stack.get(i);
            if (event.isStartElement()) {
                StartElement se = event.asStartElement();
                QName name = se.getName();
                if (!inContextGroup) {
                    this.writer.add(this.evfact.createEndElement(name, se.getNamespaces()));
                }
                if (!CONTEXT_GROUP.equals(name.getLocalPart())) continue;
                inContextGroup = false;
                continue;
            }
            if (!event.isEndElement() || !CONTEXT_GROUP.equals(event.asEndElement().getName().getLocalPart())) continue;
            inContextGroup = true;
        }
        this.writer.flush();
        this.endPart();
        this.startPart();
        for (i = 0; i < this.stack.size(); ++i) {
            XMLEvent e = (XMLEvent)this.stack.get(i);
            this.writer.add(e);
        }
        this.writer.flush();
    }

    private void readAndwrite() throws XMLStreamException, IOException {
        boolean inContextGroup = false;
        while (this.reader.hasNext()) {
            XMLEvent event = this.reader.nextEvent();
            this.writer.add(event);
            this.store(event);
            if (event.isStartElement()) {
                this.stack.push(event);
                StartElement se = event.asStartElement();
                switch (se.getName().getLocalPart()) {
                    case "group": {
                        Attribute attr = se.getAttributeByName(QNTRANSLATE);
                        if (attr == null) {
                            this.translate.push(this.translate.peek());
                            break;
                        }
                        this.translate.push("yes".equals(attr.getValue()));
                        break;
                    }
                    case "context-group": {
                        inContextGroup = true;
                        break;
                    }
                    case "trans-unit": {
                        this.stack.pop();
                        this.storeEvents = false;
                        this.processTransUnit(se);
                        if (!this.splitASAP) break;
                        this.split();
                        break;
                    }
                }
                continue;
            }
            if (event.isEndElement()) {
                if (CONTEXT_GROUP.equals(event.asEndElement().getName().getLocalPart())) {
                    this.stack.push(event);
                    inContextGroup = false;
                    continue;
                }
                if (inContextGroup) {
                    this.stack.push(event);
                    continue;
                }
                this.popUntilStartElementNameNotEqualTo(event.asEndElement().getName());
                continue;
            }
            if (!inContextGroup) continue;
            this.stack.push(event);
        }
    }

    private void popUntilStartElementNameNotEqualTo(QName endElementName) {
        for (int i = this.stack.size() - 1; 0 <= i; --i) {
            XMLEvent event = (XMLEvent)this.stack.get(i);
            this.stack.pop();
            if (event.isStartElement() && event.asStartElement().getName().equals(endElementName)) break;
        }
    }

    private void processTransUnit(StartElement start) throws XMLStreamException {
        boolean inAltTrans = false;
        this.state = null;
        this.stateQualifier = null;
        this.content = new StringBuilder();
        Attribute attr = start.getAttributeByName(QNTRANSLATE);
        this.isTranslatable = attr == null ? this.translate.peek().booleanValue() : "yes".equals(attr.getValue());
        while (this.reader.hasNext()) {
            String name;
            XMLEvent event = this.reader.nextEvent();
            this.writer.add(event);
            if (event.isEndElement()) {
                EndElement ee = event.asEndElement();
                switch (name = ee.getName().getLocalPart()) {
                    case "trans-unit": {
                        this.verifyThreshold();
                        return;
                    }
                    case "alt-trans": {
                        inAltTrans = false;
                        break;
                    }
                }
                continue;
            }
            if (!event.isStartElement()) continue;
            StartElement se = event.asStartElement();
            switch (name = se.getName().getLocalPart()) {
                case "source": {
                    if (inAltTrans) break;
                    this.processContent(se);
                    break;
                }
                case "target": {
                    if (inAltTrans) break;
                    this.getTargetAttributes(se);
                    break;
                }
                case "alt-trans": {
                    inAltTrans = true;
                }
            }
        }
    }

    private void getTargetAttributes(StartElement start) {
        Attribute attr = start.getAttributeByName(QNSTATE);
        if (attr != null) {
            this.state = attr.getValue();
        }
        if ((attr = start.getAttributeByName(QNSTATEQUALIFIER)) != null) {
            this.stateQualifier = attr.getValue();
        }
    }

    private void processContent(StartElement start) throws XMLStreamException {
        while (this.reader.hasNext()) {
            XMLEvent event = this.reader.nextEvent();
            this.writer.add(event);
            if (event.isCharacters()) {
                this.content.append(event.asCharacters().getData());
                continue;
            }
            if (event.isEndElement()) {
                String name;
                EndElement ee = event.asEndElement();
                switch (name = ee.getName().getLocalPart()) {
                    case "source": {
                        return;
                    }
                }
                continue;
            }
            if (!event.isStartElement()) continue;
            StartElement se = event.asStartElement();
            switch (se.getName().getLocalPart()) {
                case "x": 
                case "bx": 
                case "ex": 
                case "ph": 
                case "it": {
                    break;
                }
            }
        }
    }

    private void verifyThreshold() {
        if (!this.isTranslatable) {
            return;
        }
        if ("x-numeric".equals(this.stateQualifier)) {
            return;
        }
        if ("x-alphanum".equals(this.stateQualifier)) {
            return;
        }
        if ("x-punctuation".equals(this.stateQualifier)) {
            return;
        }
        this.count = (int)((long)this.count + WordCounter.count(this.content.toString(), this.srcLoc));
        this.splitASAP = this.count >= this.params.getThreshold();
    }
}

