/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.terminologyleveraging;

import java.util.LinkedHashSet;
import java.util.Set;

public class TerminologyQueryResult {
    private Term term;
    private Set<Translation> translations = new LinkedHashSet<Translation>();

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public Set<Translation> getTranslations() {
        return this.translations;
    }

    public void addTranslation(String id, String text) {
        Translation translation = new Translation();
        translation.setId(id);
        translation.setText(text);
        this.translations.add(translation);
    }

    public String toString() {
        return "TerminologyQueryResult{term=" + this.term + ", translations=" + this.translations + "}";
    }

    public static class Translation {
        private String id;
        private String text;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Translation that = (Translation)o;
            if (!this.id.equals(that.id)) {
                return false;
            }
            return this.text.equals(that.text);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.text.hashCode();
            return result;
        }

        public String toString() {
            return "Translation{id='" + this.id + "', text='" + this.text + "'}";
        }
    }

    public static class Term {
        private String id;
        private String source;
        private String termText;

        public Term() {
        }

        public Term(String id, String source, String termText) {
            this.id = id;
            this.source = source;
            this.termText = termText;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getTermText() {
            return this.termText;
        }

        public void setTermText(String termText) {
            this.termText = termText;
        }

        public String toString() {
            return "Term{id='" + this.id + "', source='" + this.source + "', termText='" + this.termText + "'}";
        }
    }
}

