/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;

@UsingParameters
public class FilterEventsToRawDocumentStep
extends BasePipelineStep {
    private IFilterWriter filterWriter;
    private File outputFile;
    private URI outputURI;
    private LocaleId targetLocale;
    private String outputEncoding;
    private OutputStream outputStream;

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @Override
    public String getName() {
        return "Filter Events to Raw Document";
    }

    @Override
    public String getDescription() {
        return "Combine filter events into a full document and pass it along as a raw document. Expects: filter events. Sends back: raw document or NO_OP if writing to a stream.";
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.handleStartDocument(event);
                return Event.createNoopEvent();
            }
            case END_DOCUMENT: {
                return this.processEndDocument(event);
            }
            case START_SUBDOCUMENT: 
            case START_GROUP: 
            case END_SUBDOCUMENT: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: 
            case DOCUMENT_PART: 
            case TEXT_UNIT: {
                this.filterWriter.handleEvent(event);
                return Event.createNoopEvent();
            }
        }
        return event;
    }

    private Event processEndDocument(Event event) {
        this.filterWriter.handleEvent(event);
        this.filterWriter.close();
        if (this.outputStream == null) {
            RawDocument input = new RawDocument(this.outputFile.toURI(), this.outputEncoding, this.targetLocale, this.targetLocale);
            return new Event(EventType.RAW_DOCUMENT, input);
        }
        return Event.createNoopEvent();
    }

    @Override
    protected Event handleStartDocument(Event event) {
        StartDocument startDoc = (StartDocument)event.getResource();
        if (this.outputEncoding == null) {
            this.outputEncoding = startDoc.getEncoding();
        }
        this.filterWriter = startDoc.getFilterWriter();
        this.filterWriter.setOptions(this.targetLocale, this.outputEncoding);
        this.filterWriter.setOutput(this.outputStream);
        if (this.isLastOutputStep()) {
            if (this.outputStream == null) {
                this.outputFile = new File(this.outputURI);
                Util.createDirectories(this.outputFile.getAbsolutePath());
                this.filterWriter.setOutput(this.outputFile.getAbsolutePath());
            }
        } else {
            try {
                if (this.outputStream == null) {
                    this.outputFile = File.createTempFile("~okapi-39_okp-fe2rd_", ".tmp");
                    this.filterWriter.setOutput(this.outputFile.getAbsolutePath());
                }
            }
            catch (Throwable e) {
                throw new OkapiIOException("Cannot create temporary output.", e);
            }
        }
        this.filterWriter.handleEvent(event);
        return event;
    }
}

