/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.step;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiFilterCreationException;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.io.InputStreamFromOutputStream;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.lib.merge.merge.SkeletonMergerWriter;
import net.sf.okapi.lib.merge.merge.TextUnitMergerSerialized;
import net.sf.okapi.lib.serialization.filter.TextUnitFlatFilter;
import net.sf.okapi.lib.serialization.step.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginalDocumentTextUnitFlatMergerStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IFilter filter;
    private IFilterConfigurationMapper fcMapper;
    private String outputEncoding;
    private LocaleId trgLoc;
    private RawDocument originalDocument;
    private SkeletonMergerWriter skelMergerWriter;
    private Parameters params = new Parameters();

    public OriginalDocumentTextUnitFlatMergerStep() {
        this.skelMergerWriter = new SkeletonMergerWriter(new TextUnitMergerSerialized());
    }

    public OriginalDocumentTextUnitFlatMergerStep(SkeletonMergerWriter skelMergerWriter) {
        this();
        this.skelMergerWriter = skelMergerWriter;
    }

    @Override
    public String getName() {
        return "Original Document TextUnit Flat Json Merger";
    }

    @Override
    public String getDescription() {
        return "TextUnit Flat Json merger which re-filters the original source file to provide the skeleton for merging.";
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALES)
    public void setTargetLocales(List<LocaleId> targetLocales) {
        this.trgLoc = targetLocales.get(0);
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.originalDocument = secondInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    protected Event handleRawDocument(final Event event) {
        this.filter = this.fcMapper.createFilter(this.originalDocument.getFilterConfigId(), this.filter);
        if (this.filter == null) {
            throw new OkapiFilterCreationException(String.format("Cannot create the filter or load the configuration for '%s'", this.originalDocument.getFilterConfigId()));
        }
        this.filter.open(this.originalDocument);
        this.skelMergerWriter.setFilter(this.filter);
        this.skelMergerWriter.setOptions(this.trgLoc, this.outputEncoding);
        final TextUnitFlatFilter textUnitFlatFilter = new TextUnitFlatFilter();
        InputStreamFromOutputStream<Void> is = new InputStreamFromOutputStream<Void>(){
            OkapiMergeException error;

            @Override
            protected Void produce(OutputStream sink) throws Exception {
                try {
                    OriginalDocumentTextUnitFlatMergerStep.this.skelMergerWriter.setOutput(sink);
                    textUnitFlatFilter.open(event.getRawDocument());
                    while (textUnitFlatFilter.hasNext()) {
                        OriginalDocumentTextUnitFlatMergerStep.this.skelMergerWriter.handleEvent(textUnitFlatFilter.next());
                    }
                }
                catch (Exception e) {
                    this.error = new OkapiMergeException("Error merging from original file", e);
                }
                finally {
                    textUnitFlatFilter.close();
                    OriginalDocumentTextUnitFlatMergerStep.this.skelMergerWriter.close();
                    OriginalDocumentTextUnitFlatMergerStep.this.originalDocument.close();
                }
                return null;
            }

            @Override
            protected void afterClose() {
                if (this.error != null) {
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        OriginalDocumentTextUnitFlatMergerStep.this.logger.error("Error closing InputStreamFromOutputStream", (Throwable)e);
                    }
                    throw this.error;
                }
            }
        };
        return new Event(EventType.RAW_DOCUMENT, new RawDocument(is, this.outputEncoding, this.trgLoc));
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public SkeletonMergerWriter getSkelMergerWriter() {
        return this.skelMergerWriter;
    }

    public void setSkelMergerWriter(SkeletonMergerWriter skelMergerWriter) {
        this.skelMergerWriter = skelMergerWriter;
    }
}

