/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.ts;

import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

public class Parameters
extends StringParameters
implements ISimplifierRulesParameters {
    private static final String ESCAPEGT = "escapeGT";
    private static final String DECODEBYTEVALUES = "decodeByteValues";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private InlineCodeFinder codeFinder;

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public boolean getEscapeGT() {
        return this.getBoolean(ESCAPEGT);
    }

    public void setEscapeGT(boolean escapeGT) {
        this.setBoolean(ESCAPEGT, escapeGT);
    }

    public boolean getDecodeByteValues() {
        return this.getBoolean(DECODEBYTEVALUES);
    }

    public void setDecodeByteValues(boolean decodeByteValues) {
        this.setBoolean(DECODEBYTEVALUES, decodeByteValues);
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public void reset() {
        super.reset();
        this.setEscapeGT(false);
        this.setDecodeByteValues(false);
        this.setUseCodeFinder(true);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("%s, %d, {1}, \\n, \\r, \\t, etc.");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("%(([-0+#]?)[-0+#]?)((\\d\\$)?)(([\\d\\*]*)(\\.[\\d\\*]*)?)[dioxXucsfeEgGpn]");
        this.codeFinder.addRule("(\\\\r\\\\n)|\\\\a|\\\\b|\\\\f|\\\\n|\\\\r|\\\\t|\\\\v");
        this.codeFinder.addRule("\\{\\d[^\\\\]*?\\}");
        this.setSimplifierRules(null);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }
}

