/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.table.base;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.filters.TextProcessingResult;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.plaintext.base.BasePlainTextFilter;
import net.sf.okapi.filters.table.base.Parameters;
import net.sf.okapi.filters.table.csv.CommaSeparatedValuesFilter;

public class BaseTableFilter
extends BasePlainTextFilter {
    public static final String FILTER_NAME = "okf_csv";
    public static final String FILTER_MIME = "text/csv";
    public static final String FILTER_CONFIG = "okf_csv";
    public static String ROW_NUMBER = "row_number";
    public static String COLUMN_NUMBER = "column_number";
    private Parameters params;
    protected List<Integer> sourceColumns;
    protected List<Integer> targetColumns;
    protected List<Integer> targetSourceRefs;
    protected List<Integer> commentColumns;
    protected List<Integer> commentSourceRefs;
    protected List<Integer> sourceIdColumns;
    protected List<Integer> sourceIdSourceRefs;
    protected List<String> columnNames;
    protected List<String> sourceIdSuffixes;
    protected List<LocaleId> targetLanguages;
    private int rowNumber = 0;
    private boolean inHeaderArea = true;
    private boolean sendListedMode = false;
    private boolean inMultilineColumnNames = false;
    private boolean isHeaderLine;
    private boolean isColumnNames;
    private boolean isFixedNumColumns;
    private LocaleId columnDefinedSource;
    private List<LocaleId> columnDefinedTargets;

    public BaseTableFilter() {
        this.setName("okf_csv");
        this.setMimeType(FILTER_MIME);
        this.columnNames = new ArrayList<String>();
        this.setParameters(new Parameters());
    }

    @Override
    protected void init() {
        this.params = this.getParameters(Parameters.class);
        super.init();
        this.sourceIdColumns = ListUtil.stringAsIntList(this.params.sourceIdColumns);
        this.sourceColumns = ListUtil.stringAsIntList(this.params.sourceColumns);
        this.targetColumns = ListUtil.stringAsIntList(this.params.targetColumns);
        this.targetLanguages = ListUtil.stringAsLanguageList(this.params.targetLanguages);
        this.commentColumns = ListUtil.stringAsIntList(this.params.commentColumns);
        this.targetSourceRefs = ListUtil.stringAsIntList(this.params.targetSourceRefs);
        this.commentSourceRefs = ListUtil.stringAsIntList(this.params.commentSourceRefs);
        this.sourceIdSourceRefs = ListUtil.stringAsIntList(this.params.sourceIdSourceRefs);
        this.sourceIdSuffixes = ListUtil.stringAsList(this.params.sourceIdSuffixes);
        this.sendListedMode = this.params.sendColumnsMode == 1;
        this.setMultilingual(this.sendListedMode && this.targetColumns.size() > 0);
        this.rowNumber = 0;
        if (this.columnNames != null) {
            this.columnNames.clear();
        } else {
            this.columnNames = new ArrayList<String>();
        }
        this.inMultilineColumnNames = false;
        this.columnDefinedSource = null;
        this.columnDefinedTargets = new LinkedList<LocaleId>();
    }

    @Override
    protected TextProcessingResult processLine(TextContainer lineContainer) {
        if (lineContainer == null || !this.isMerging() && lineContainer.isEmpty()) {
            return TextProcessingResult.REJECTED;
        }
        Property lineNumProp = lineContainer.getProperty("line_number");
        long lineNum = new Long(lineNumProp.getValue());
        this.updateLineInfo(lineNum);
        if (this.isColumnNames && (this.srcLang == LocaleId.EMPTY || this.trgLang == LocaleId.EMPTY)) {
            ArrayList<String> columnNames = new ArrayList<String>();
            if (this instanceof CommaSeparatedValuesFilter) {
                for (String column : ListUtil.stringAsArray(lineContainer.getCodedText(), this.getFieldDelimiter())) {
                    columnNames.add(StringUtil.removeQualifiers(column.trim(), this.getFieldQualifier()));
                }
            } else {
                ArrayList<ITextUnit> cn = new ArrayList<ITextUnit>();
                this.extractCells(cn, lineContainer, lineNum);
                for (ITextUnit tu : cn) {
                    columnNames.add(tu.getSource().getCodedText().trim());
                }
            }
            int i = 1;
            for (String l : columnNames) {
                if (LocaleId.EMPTY == this.srcLang && this.isSource(i)) {
                    try {
                        this.columnDefinedSource = LocaleId.fromString(l);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (LocaleId.EMPTY == this.trgLang && this.isTarget(i)) {
                    try {
                        this.columnDefinedTargets.add(LocaleId.fromString(l));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            PipelineParameters pp = null;
            if (this.columnDefinedSource != null) {
                pp = new PipelineParameters(this.startDoc, this.input, null, null);
                pp.setSourceLocale(this.columnDefinedSource);
                this.srcLang = this.columnDefinedSource;
            }
            if (!this.columnDefinedTargets.isEmpty()) {
                if (pp == null) {
                    pp = new PipelineParameters(this.startDoc, this.input, null, null);
                }
                if (this.columnDefinedTargets.size() <= 1) {
                    pp.setTargetLocale(this.columnDefinedTargets.get(0));
                    this.trgLang = this.columnDefinedTargets.get(0);
                } else {
                    pp.setTargetLocales(this.columnDefinedTargets);
                }
            }
            if (pp != null) {
                this.sendEvent(EventType.PIPELINE_PARAMETERS, pp);
            }
        }
        if (this.inHeaderArea && this.params.sendHeaderMode == 0) {
            return TextProcessingResult.REJECTED;
        }
        if (this.inHeaderArea && !this.isColumnNames && this.params.sendHeaderMode == 1) {
            return TextProcessingResult.REJECTED;
        }
        this.rowNumber = this.inHeaderArea ? 0 : (this.rowNumber <= 0 ? 1 : ++this.rowNumber);
        if (this.isHeaderLine) {
            lineContainer.setProperty(new Property(ROW_NUMBER, String.valueOf(this.rowNumber), true));
            return super.sendAsSource(lineContainer);
        }
        ArrayList<ITextUnit> cells = new ArrayList<ITextUnit>();
        TextProcessingResult res = this.extractCells(cells, lineContainer, lineNum);
        switch (res) {
            case REJECTED: {
                return res;
            }
            case DELAYED_DECISION: {
                if (this.isColumnNames) {
                    this.inMultilineColumnNames = true;
                }
                return res;
            }
        }
        if (this.isColumnNames) {
            this.inMultilineColumnNames = false;
        }
        if (Util.isEmpty(cells)) {
            return super.sendAsSource(lineContainer);
        }
        for (int i = 0; i < cells.size(); ++i) {
            ITextUnit cell = (ITextUnit)cells.get(i);
            if (!Util.isEmpty(cell.getId())) continue;
            cell.setId(String.format("%d_%d", lineNum, i + 1));
        }
        if (this.processCells(cells, lineNum)) {
            return TextProcessingResult.ACCEPTED;
        }
        return TextProcessingResult.REJECTED;
    }

    protected TextProcessingResult extractCells(List<ITextUnit> cells, TextContainer lineContainer, long lineNum) {
        if (cells != null) {
            cells.add(TextUnitUtil.buildGenericTU(lineContainer));
        }
        return TextProcessingResult.ACCEPTED;
    }

    protected String getFieldDelimiter() {
        return null;
    }

    protected String getFieldQualifier() {
        return null;
    }

    protected boolean processCells(List<ITextUnit> cells, long lineNum) {
        if (this.params.sendColumnsMode == 0) {
            return false;
        }
        if (cells == null) {
            return false;
        }
        this.updateLineInfo(lineNum);
        if (this.isFixedNumColumns) {
            if (cells.size() < this.params.numColumns) {
                for (int i = cells.size(); i < this.params.numColumns; ++i) {
                    cells.add(TextUnitUtil.buildGenericTU(""));
                }
            }
            if (cells.size() > this.params.numColumns) {
                cells.subList(this.params.numColumns, cells.size()).clear();
            }
        }
        if (this.isColumnNames) {
            this.columnNames.clear();
            for (ITextUnit tu : cells) {
                String st = TextUnitUtil.getSourceText(tu).trim();
                this.columnNames.add(st);
            }
            if (this.params.detectColumnsMode == 1) {
                this.params.numColumns = cells.size();
            }
        }
        boolean tuSent = false;
        int startGroupIndex = this.getQueueSize();
        if (this.params.sendColumnsMode == 2 || this.inHeaderArea) {
            for (int i = 0; i < cells.size(); ++i) {
                if (i > 0) {
                    this.sendAsSkeleton(this.getFieldDelimiter());
                }
                ITextUnit cell = cells.get(i);
                int colNumber = i + 1;
                if (TextUnitUtil.isEmpty(cell, true)) {
                    this.sendAsSkeleton(cell);
                    continue;
                }
                cell.setSourceProperty(new Property("line_number", String.valueOf(lineNum), true));
                cell.setSourceProperty(new Property(COLUMN_NUMBER, String.valueOf(colNumber), true));
                cell.setSourceProperty(new Property(ROW_NUMBER, String.valueOf(this.rowNumber), true));
                if (this.sendAsSource(cell) != TextProcessingResult.ACCEPTED) continue;
                tuSent = true;
            }
        } else if (this.sendListedMode) {
            ITextUnit cell;
            int i;
            String recordId = "";
            for (i = 0; i < cells.size(); ++i) {
                ITextUnit tu;
                cell = cells.get(i);
                TextUnit temp = new TextUnit("temp", TextUnitUtil.getSourceText(cell));
                TextUnitUtil.trimTU(temp, true, true);
                String trimmedCell = TextUnitUtil.getSourceText(temp);
                int colNumber = i + 1;
                if (this.isRecordId(colNumber)) {
                    recordId = trimmedCell;
                }
                if (this.isSourceId(colNumber)) {
                    tu = this.getSourceFromIdRef(cells, colNumber);
                    if (tu == null) continue;
                    if (TextUnitUtil.isEmpty(cell, true)) {
                        String recordID = "";
                        int index = this.params.recordIdColumn - 1;
                        if (Util.checkIndex(index, cells)) {
                            recordID = TextUnitUtil.getSourceText(cells.get(index));
                        }
                        if (recordID != null) {
                            recordID = recordID.trim();
                        }
                        String colSuffix = this.getSuffixFromSourceRef(colNumber);
                        if (Util.isEmpty(recordID) || Util.isEmpty(colSuffix)) continue;
                        tu.setName(recordID + colSuffix);
                        continue;
                    }
                    tu.setName(trimmedCell);
                    continue;
                }
                if (this.isComment(colNumber)) {
                    tu = this.getSourceFromCommentRef(cells, colNumber);
                    if (tu == null || Util.isEmpty(trimmedCell)) continue;
                    NoteAnnotation notes = new NoteAnnotation();
                    Note n = new Note(trimmedCell);
                    notes.add(n);
                    tu.setAnnotation(notes);
                    continue;
                }
                if (!this.isSource(colNumber) || cell == null) continue;
                cell.setSourceProperty(new Property("line_number", String.valueOf(lineNum), true));
                cell.setSourceProperty(new Property(COLUMN_NUMBER, String.valueOf(colNumber), true));
                cell.setSourceProperty(new Property(ROW_NUMBER, String.valueOf(this.rowNumber), true));
            }
            for (i = 0; i < cells.size(); ++i) {
                cell = cells.get(i);
                int colNumber = i + 1;
                if (this.params.subfilter != null && i > 0) {
                    this.sendAsSkeleton(this.getFieldDelimiter());
                }
                if (this.isSource(colNumber)) {
                    if (cell == null) continue;
                    if (Util.isEmpty(cell.getName()) && this.sendListedMode && !Util.isEmpty(recordId)) {
                        cell.setName(recordId + this.getSuffix(colNumber));
                    }
                    if (this.params.subfilter == null) {
                        cell.setIsReferent(true);
                    }
                    this.sendAsSource(cell, false);
                    tuSent = true;
                    continue;
                }
                if (this.isTarget(colNumber) || this.params.subfilter == null) continue;
                this.sendAsSkeleton(cell);
            }
            if (this.params.subfilter == null) {
                GenericSkeleton skel = new GenericSkeleton();
                this.sendEvent(EventType.DOCUMENT_PART, new DocumentPart(null, false, new GenericSkeleton()));
                skel = this.getActiveSkeleton();
                for (int i2 = 0; i2 < cells.size(); ++i2) {
                    if (i2 > 0) {
                        this.sendAsSkeleton(this.getFieldDelimiter());
                    }
                    ITextUnit cell2 = cells.get(i2);
                    int colNumber = i2 + 1;
                    if (this.isSource(colNumber)) {
                        if (cell2 == null) continue;
                        GenericSkeleton tuSkel = (GenericSkeleton)cell2.getSkeleton();
                        tuSkel.changeSelfReferents(cell2);
                        skel.add(tuSkel);
                        continue;
                    }
                    if (this.isTarget(colNumber)) {
                        ITextUnit tu = this.getSourceFromTargetRef(cells, colNumber);
                        if (tu == null) {
                            this.sendAsSkeleton(cell2);
                            continue;
                        }
                        LocaleId language = this.getLanguageFromTargetRef(colNumber);
                        if (Util.isNullOrEmpty(language)) {
                            this.sendAsSkeleton(cell2);
                            continue;
                        }
                        this.sendAsTarget(cell2, tu, language);
                        continue;
                    }
                    this.sendAsSkeleton(cell2);
                }
            }
        }
        if (tuSent) {
            StartGroup startGroup = new StartGroup("");
            if (startGroup != null) {
                startGroup.setType("row");
            }
            this.sendEvent(startGroupIndex, EventType.START_GROUP, startGroup);
            this.sendEvent(EventType.END_GROUP, new Ending(""));
        }
        return true;
    }

    public List<String> getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<String>();
        }
        return this.columnNames;
    }

    private boolean isSource(int colNumber) {
        return this.sourceColumns == null ? false : this.sourceColumns.contains(colNumber);
    }

    private boolean isSourceId(int colNumber) {
        return this.sourceIdColumns == null ? false : this.sourceIdColumns.contains(colNumber);
    }

    private boolean isTarget(int colNumber) {
        return this.targetColumns == null ? false : this.targetColumns.contains(colNumber);
    }

    private boolean isComment(int colNumber) {
        return this.commentColumns == null ? false : this.commentColumns.contains(colNumber);
    }

    private boolean isRecordId(int colNumber) {
        return this.params.recordIdColumn > 0 && colNumber == this.params.recordIdColumn;
    }

    private ITextUnit getSource(List<ITextUnit> cells, int colNum, List<Integer> columnsList, List<Integer> refList) {
        if (columnsList == null) {
            return null;
        }
        int index = columnsList.indexOf(colNum);
        if (!Util.checkIndex(index, refList)) {
            return null;
        }
        int ref = refList.get(index) - 1;
        if (!Util.checkIndex(ref, cells)) {
            return null;
        }
        return cells.get(ref);
    }

    private ITextUnit getSourceFromTargetRef(List<ITextUnit> cells, int colNum) {
        return this.getSource(cells, colNum, this.targetColumns, this.targetSourceRefs);
    }

    private ITextUnit getSourceFromIdRef(List<ITextUnit> cells, int colNum) {
        return this.getSource(cells, colNum, this.sourceIdColumns, this.sourceIdSourceRefs);
    }

    private ITextUnit getSourceFromCommentRef(List<ITextUnit> cells, int colNum) {
        return this.getSource(cells, colNum, this.commentColumns, this.commentSourceRefs);
    }

    private LocaleId getLanguageFromTargetRef(int colNum) {
        if (this.targetColumns == null) {
            return LocaleId.EMPTY;
        }
        int index = this.targetColumns.indexOf(colNum);
        if (!Util.checkIndex(index, this.targetLanguages)) {
            return this.getTargetLocale();
        }
        return this.targetLanguages.get(index);
    }

    private String getSuffixFromSourceRef(int colNum) {
        if (this.sourceIdColumns == null) {
            return "";
        }
        int index = this.sourceIdColumns.indexOf(colNum);
        if (!Util.checkIndex(index, this.sourceIdSuffixes)) {
            return "";
        }
        return this.sourceIdSuffixes.get(index);
    }

    private String getSuffix(int colNum) {
        if (this.sourceColumns == null) {
            return "";
        }
        int index = this.sourceColumns.indexOf(colNum);
        if (!Util.checkIndex(index, this.sourceIdSuffixes)) {
            return "";
        }
        return this.sourceIdSuffixes.get(index);
    }

    private void updateLineInfo(long lineNum) {
        this.inHeaderArea = lineNum < (long)this.params.valuesStartLineNum;
        this.isColumnNames = this.inHeaderArea && (lineNum == (long)this.params.columnNamesLineNum || lineNum > (long)this.params.columnNamesLineNum && this.inMultilineColumnNames);
        this.isHeaderLine = this.inHeaderArea && !this.isColumnNames;
        this.isFixedNumColumns = this.params.detectColumnsMode == 2 && this.params.numColumns > 0 || this.params.detectColumnsMode == 1 && !this.inHeaderArea;
    }

    protected boolean isSendListedMode() {
        return this.sendListedMode;
    }

    protected boolean isMerging() {
        return false;
    }
}

