/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.plaintext.base;

import net.sf.okapi.common.AbstractGroupParameters;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.filters.WrapMode;

public class Parameters
extends AbstractGroupParameters {
    public boolean unescapeSource;
    public boolean trimLeading;
    public boolean trimTrailing;
    public boolean preserveWS;
    public boolean useCodeFinder;
    public String codeFinderRules;
    public WrapMode wrapMode;
    private InlineCodeFinder codeFinder;
    public String subfilter;

    @Override
    protected void load(ParametersString buffer) {
        this.unescapeSource = buffer.getBoolean("unescapeSource", true);
        this.trimLeading = buffer.getBoolean("trimLeading", false);
        this.trimTrailing = buffer.getBoolean("trimTrailing", false);
        this.preserveWS = buffer.getBoolean("preserveWS", true);
        this.useCodeFinder = buffer.getBoolean("useCodeFinder", false);
        this.codeFinderRules = buffer.getString("codeFinderRules", this.codeFinder.toString());
        this.wrapMode = WrapMode.values()[buffer.getInteger("wrapMode", WrapMode.NONE.ordinal())];
        this.subfilter = buffer.getString("subfilter", this.subfilter);
    }

    @Override
    public void reset() {
        this.unescapeSource = true;
        this.trimLeading = false;
        this.trimTrailing = false;
        this.preserveWS = true;
        this.useCodeFinder = false;
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.addRule("%(([-0+#]?)[-0+#]?)((\\d\\$)?)(([\\d\\*]*)(\\.[\\d\\*]*)?)[dioxXucsfeEgGpn]");
        this.codeFinder.addRule("(\\\\r\\\\n)|\\\\a|\\\\b|\\\\f|\\\\n|\\\\r|\\\\t|\\\\v");
        this.codeFinderRules = this.codeFinder.toString();
        this.wrapMode = WrapMode.NONE;
        this.subfilter = null;
    }

    @Override
    protected void save(ParametersString buffer) {
        buffer.setBoolean("unescapeSource", this.unescapeSource);
        buffer.setBoolean("trimLeading", this.trimLeading);
        buffer.setBoolean("trimTrailing", this.trimTrailing);
        buffer.setBoolean("preserveWS", this.preserveWS);
        buffer.setBoolean("useCodeFinder", this.useCodeFinder);
        buffer.setString("codeFinderRules", this.codeFinderRules);
        buffer.setInteger("wrapMode", this.wrapMode.ordinal());
        buffer.setString("subfilter", this.subfilter);
    }
}

