/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.ChronoUnit;

interface SerialDateTime {
    public LocalDateTime asLocalDateTime();

    public static class Epoch1904Based
    implements SerialDateTime {
        private static final LocalDateTime BASE_DATE_TIME = LocalDate.of(1904, Month.JANUARY, 1).atStartOfDay();
        private final SerialDateTime serialDateTime;

        Epoch1904Based(String value) {
            this(new Default(value, BASE_DATE_TIME));
        }

        Epoch1904Based(SerialDateTime serialDateTime) {
            this.serialDateTime = serialDateTime;
        }

        @Override
        public LocalDateTime asLocalDateTime() {
            return this.serialDateTime.asLocalDateTime();
        }
    }

    public static class Epoch1900Based
    implements SerialDateTime {
        private static final LocalDateTime BASE_DATE_TIME = LocalDate.of(1899, Month.DECEMBER, 31).atStartOfDay();
        private final SerialDateTime serialDateTime;

        Epoch1900Based(String value) {
            this(new Default(value, BASE_DATE_TIME));
        }

        Epoch1900Based(SerialDateTime serialDateTime) {
            this.serialDateTime = serialDateTime;
        }

        @Override
        public LocalDateTime asLocalDateTime() {
            return this.serialDateTime.asLocalDateTime().isAfter(BASE_DATE_TIME.plusDays(59L)) ? this.serialDateTime.asLocalDateTime().minusDays(1L) : this.serialDateTime.asLocalDateTime();
        }
    }

    public static class Default
    implements SerialDateTime {
        private static final int SECONDS_PER_DAY = 86400;
        private static final BigDecimal NANOSECONDS_PER_DAY = BigDecimal.valueOf(8.64E13);
        private static final BigDecimal HALF_UP_ROUNDING_MILLISECONDS = BigDecimal.valueOf(500000.0);
        private final String value;
        private final LocalDateTime baseDateTime;

        Default(String value, LocalDateTime baseDateTime) {
            this.value = value;
            this.baseDateTime = baseDateTime;
        }

        @Override
        public LocalDateTime asLocalDateTime() {
            BigDecimal bd = new BigDecimal(this.value);
            int days = bd.intValue();
            BigDecimal fractionOfDay = bd.subtract(BigDecimal.valueOf(days));
            return this.baseDateTime.plusDays(days).plusNanos(fractionOfDay.multiply(NANOSECONDS_PER_DAY).add(HALF_UP_ROUNDING_MILLISECONDS).longValue()).truncatedTo(ChronoUnit.MILLIS);
        }
    }
}

