/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ChunkContainer;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunProperties;

final class RunContainer
implements Chunk {
    private static final EnumSet<Type> RUN_CONTAINER_TYPES = EnumSet.of(Type.HYPERLINK, Type.SMART_TAG, Type.STRUCTURED_DOCUMENT_TAG);
    private static final String STRUCTURAL_DOCUMENT_TAG_CONTENT = "sdtContent";
    private final XMLEventFactory eventFactory;
    private final StartElement startElement;
    private final Type type;
    private final Markup startMarkup;
    private final List<Chunk> chunks;
    private final Markup endMarkup;

    private RunContainer(XMLEventFactory eventFactory, StartElement startElement, Type type, Markup startMarkup, List<Chunk> chunks, Markup endMarkup) {
        this.eventFactory = eventFactory;
        this.startElement = startElement;
        this.type = type;
        this.startMarkup = startMarkup;
        this.chunks = chunks;
        this.endMarkup = endMarkup;
    }

    static boolean isStart(XMLEvent e) {
        return e.isStartElement() && RUN_CONTAINER_TYPES.contains((Object)Type.fromString(e.asStartElement().getName().getLocalPart()));
    }

    static boolean isPropertiesStart(XMLEvent e) {
        return e.isStartElement() && ("smartTagPr".equals(e.asStartElement().getName().getLocalPart()) || "sdtPr".equals(e.asStartElement().getName().getLocalPart()) || "sdtEndPr".equals(e.asStartElement().getName().getLocalPart()));
    }

    static boolean isContentStart(XMLEvent e) {
        return e.isStartElement() && STRUCTURAL_DOCUMENT_TAG_CONTENT.equals(e.asStartElement().getName().getLocalPart());
    }

    static boolean isContentEnd(XMLEvent e) {
        return e.isEndElement() && STRUCTURAL_DOCUMENT_TAG_CONTENT.equals(e.asEndElement().getName().getLocalPart());
    }

    Type type() {
        return this.type;
    }

    List<XMLEvent> startMarkupEvents() {
        return this.startMarkup.getEvents();
    }

    List<Chunk> getChunks() {
        return this.chunks;
    }

    List<XMLEvent> endMarkupEvents() {
        return this.endMarkup.getEvents();
    }

    boolean containsVisibleText() {
        for (Chunk chunk : this.getChunks()) {
            if (!(chunk instanceof Run) || !((Run)chunk).containsVisibleText()) continue;
            return true;
        }
        return false;
    }

    RunProperties getDefaultRunProperties() {
        return this.chunks.size() > 0 && this.chunks.get(0) instanceof Run ? ((Run)this.chunks.get(0)).getProperties() : new RunProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "rPr");
    }

    RunProperties getDefaultCombinedRunProperties() {
        return this.chunks.size() > 0 && this.chunks.get(0) instanceof Run ? ((Run)this.chunks.get(0)).getCombinedProperties() : new RunProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "rPr");
    }

    @Override
    public void apply(FontMappings fontMappings) {
        this.startMarkup.apply(fontMappings);
        this.chunks.forEach(c -> c.apply(fontMappings));
        this.endMarkup.apply(fontMappings);
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.addAll(this.startMarkup.getEvents());
        for (Chunk chunk : this.chunks) {
            events.addAll(chunk.getEvents());
        }
        events.addAll(this.endMarkup.getEvents());
        return events;
    }

    public String toString() {
        return "RunContainer(" + this.type + ", " + this.chunks.size() + ")[" + this.chunks + "]";
    }

    static final class Builder
    implements ChunkContainer {
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private Type type;
        private Markup startMarkup = new Block.Markup(new Markup.General(new ArrayList<MarkupComponent>()));
        private List<Chunk> chunks = new ArrayList<Chunk>();
        private Markup endMarkup = new Block.Markup(new Markup.General(new ArrayList<MarkupComponent>()));

        Builder(XMLEventFactory eventFactory, StartElement startElement) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
        }

        void addType(Type type) {
            this.type = type;
        }

        void addToStartMarkup(MarkupComponent component) {
            this.startMarkup.addComponent(component);
        }

        void add(List<Chunk> chunks) {
            this.chunks.addAll(chunks);
        }

        @Override
        public void add(Chunk chunk) {
            this.chunks.add(chunk);
        }

        void addToEndMarkup(MarkupComponent component) {
            this.endMarkup.addComponent(component);
        }

        RunContainer build() {
            return new RunContainer(this.eventFactory, this.startElement, this.type, this.startMarkup, this.chunks, this.endMarkup);
        }
    }

    static enum Type {
        HYPERLINK("hyperlink"),
        SMART_TAG("smartTag"),
        STRUCTURED_DOCUMENT_TAG("sdt"),
        UNSUPPORTED("");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }

        static Type fromString(String tagName) {
            if (tagName == null) {
                return UNSUPPORTED;
            }
            for (Type type : Type.values()) {
                if (!type.value().equals(tagName)) continue;
                return type;
            }
            return UNSUPPORTED;
        }
    }
}

