/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ExcelStyleDefinition;
import net.sf.okapi.filters.openxml.StyleDefinitionsReader;

final class ExcelStyleDefinitionsReader
implements StyleDefinitionsReader {
    private static final String UNEXPECTED_STRUCTURE = "Unexpected styles structure: ";
    private final ConditionalParameters conditionalParameters;
    private final XMLEventFactory eventFactory;
    private final XMLEventReader eventReader;
    private final Cache cache;

    ExcelStyleDefinitionsReader(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, XMLEventReader eventReader) {
        this.conditionalParameters = conditionalParameters;
        this.eventFactory = eventFactory;
        this.eventReader = eventReader;
        this.cache = new Cache();
    }

    StartDocument startDocument() throws XMLStreamException {
        if (this.cache.startDocumentAvailable()) {
            return this.cache.startDocument;
        }
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!event.isStartDocument()) continue;
            this.cache.startDocument = (StartDocument)event;
            return this.cache.startDocument;
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("the start document event is absent"));
    }

    @Override
    public StartElement startElement() throws XMLStreamException {
        if (!this.cache.startDocumentAvailable()) {
            this.startDocument();
        }
        if (this.cache.startElementAvailable()) {
            return this.cache.startElement;
        }
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement se = event.asStartElement();
            if (!"styleSheet".equals(event.asStartElement().getName().getLocalPart())) continue;
            this.cache.startElement = se;
            return this.cache.startElement;
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("the start element is absent"));
    }

    ExcelStyleDefinition.NumberFormats numberFormats() throws XMLStreamException {
        if (!this.cache.startElementAvailable()) {
            this.startElement();
        }
        if (this.cache.numberFormatsAvailable()) {
            return this.cache.numberFormats;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.numberFormatsAvailable()) {
            this.cache.numberFormats = new ExcelStyleDefinition.NumberFormats(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "fonts"));
        }
        return this.cache.numberFormats;
    }

    ExcelStyleDefinition.Fonts fonts() throws XMLStreamException {
        if (!this.cache.startDocumentAvailable()) {
            this.startDocument();
        }
        if (this.cache.fontsAvailable()) {
            return this.cache.fonts;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.fontsAvailable()) {
            this.cache.fonts = new ExcelStyleDefinition.Fonts(this.conditionalParameters, this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "fonts"));
        }
        return this.cache.fonts;
    }

    ExcelStyleDefinition.Fills fills() throws XMLStreamException {
        if (!this.cache.fillsAvailable()) {
            this.fonts();
        }
        if (this.cache.fillsAvailable()) {
            return this.cache.fills;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.fillsAvailable()) {
            this.cache.fills = new ExcelStyleDefinition.Fills(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "fills"));
        }
        return this.cache.fills;
    }

    ExcelStyleDefinition.Borders borders() throws XMLStreamException {
        if (!this.cache.fontsAvailable()) {
            this.fonts();
        }
        if (this.cache.bordersAvailable()) {
            return this.cache.borders;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.bordersAvailable()) {
            this.cache.borders = new ExcelStyleDefinition.Borders(new ExcelStyleDefinition.Default(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "borders")));
        }
        return this.cache.borders;
    }

    ExcelStyleDefinition.CellStyleFormats cellStyleFormats() throws XMLStreamException {
        if (!this.cache.bordersAvailable()) {
            this.borders();
        }
        if (this.cache.cellStyleFormatsAvailable()) {
            return this.cache.cellStyleFormats;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.cellStyleFormatsAvailable()) {
            this.cache.cellStyleFormats = new ExcelStyleDefinition.CellStyleFormats(new ExcelStyleDefinition.CellFormats(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "cellStyleXfs")));
        }
        return this.cache.cellStyleFormats;
    }

    ExcelStyleDefinition.CellFormats cellFormats() throws XMLStreamException {
        if (!this.cache.cellStyleFormatsAvailable()) {
            this.cellStyleFormats();
        }
        if (this.cache.cellFormatsAvailable()) {
            return this.cache.cellFormats;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.cellFormatsAvailable()) {
            this.cache.cellFormats = new ExcelStyleDefinition.CellFormats(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "cellXfs"));
        }
        return this.cache.cellFormats;
    }

    ExcelStyleDefinition.CellStyles cellStyles() throws XMLStreamException {
        if (!this.cache.cellFormatsAvailable()) {
            this.cellFormats();
        }
        if (this.cache.cellStylesAvailable()) {
            return this.cache.cellStyles;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.cellStylesAvailable()) {
            this.cache.cellStyles = new ExcelStyleDefinition.CellStyles(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "cellStyles"));
        }
        return this.cache.cellStyles;
    }

    ExcelStyleDefinition.DifferentialFormats differentialFormats() throws XMLStreamException {
        if (!this.cache.cellStylesAvailable()) {
            this.cellStyles();
        }
        if (this.cache.differentialFormatsAvailable()) {
            return this.cache.differentialFormats;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.differentialFormatsAvailable()) {
            this.cache.differentialFormats = new ExcelStyleDefinition.DifferentialFormats(this.conditionalParameters, this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "dxfs"));
        }
        return this.cache.differentialFormats;
    }

    ExcelStyleDefinition.TableStyles tableStyles() throws XMLStreamException {
        if (!this.cache.differentialFormatsAvailable()) {
            this.differentialFormats();
        }
        if (this.cache.tableStylesAvailable()) {
            return this.cache.tableStyles;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.tableStylesAvailable()) {
            this.cache.tableStyles = new ExcelStyleDefinition.TableStyles(new ExcelStyleDefinition.Default(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "tableStyles")));
        }
        return this.cache.tableStyles;
    }

    ExcelStyleDefinition.Colors colors() throws XMLStreamException {
        if (!this.cache.tableStylesAvailable()) {
            this.tableStyles();
        }
        if (this.cache.colorsAvailable()) {
            return this.cache.colors;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.colorsAvailable()) {
            this.cache.colors = new ExcelStyleDefinition.Colors(new ExcelStyleDefinition.Default(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "colors")));
        }
        return this.cache.colors;
    }

    ExcelStyleDefinition.Extensions extensions() throws XMLStreamException {
        if (!this.cache.colorsAvailable()) {
            this.colors();
        }
        if (this.cache.extensionsAvailable()) {
            return this.cache.extensions;
        }
        this.cacheStyleDefinitionOrEndElement();
        if (!this.cache.extensionsAvailable()) {
            this.cache.extensions = new ExcelStyleDefinition.Extensions(new ExcelStyleDefinition.Default(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName().getPrefix(), this.startElement().getName().getNamespaceURI(), "extLst")));
        }
        return this.cache.extensions;
    }

    private void cacheStyleDefinitionOrEndElement() throws XMLStreamException {
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isStartElement()) {
                this.cacheStyleDefinitionFrom(event.asStartElement());
                break;
            }
            if (!event.isEndElement() || !"styleSheet".equals(event.asEndElement().getName().getLocalPart())) continue;
            this.cache.endElement = event.asEndElement();
            break;
        }
    }

    void cacheStyleDefinitionFrom(StartElement startElement) throws XMLStreamException {
        switch (startElement.getName().getLocalPart()) {
            case "numFmts": {
                this.cacheNumberFormatsFrom(startElement);
                break;
            }
            case "fonts": {
                this.cacheFontsFrom(startElement);
                break;
            }
            case "fills": {
                this.cacheFillsFrom(startElement);
                break;
            }
            case "borders": {
                this.cacheBordersFrom(startElement);
                break;
            }
            case "cellStyleXfs": {
                this.cacheCellStyleFormatsFrom(startElement);
                break;
            }
            case "cellXfs": {
                this.cacheCellFormatsFrom(startElement);
                break;
            }
            case "cellStyles": {
                this.cacheCellStylesFrom(startElement);
                break;
            }
            case "dxfs": {
                this.cacheDifferentialFormatsFrom(startElement);
                break;
            }
            case "tableStyles": {
                this.cacheTableStylesFrom(startElement);
                break;
            }
            case "colors": {
                this.cacheColorsFrom(startElement);
                break;
            }
            case "extLst": {
                this.cacheExtensionsFrom(startElement);
                break;
            }
            default: {
                throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("unsupported element: ").concat(startElement.getName().getLocalPart()));
            }
        }
    }

    private void cacheNumberFormatsFrom(StartElement startElement) throws XMLStreamException {
        this.cache.numberFormats = new ExcelStyleDefinition.NumberFormats(this.eventFactory, startElement);
        this.cache.numberFormats.readWith(this.eventReader);
    }

    private void cacheFontsFrom(StartElement startElement) throws XMLStreamException {
        this.cache.fonts = new ExcelStyleDefinition.Fonts(this.conditionalParameters, this.eventFactory, startElement);
        this.cache.fonts.readWith(this.eventReader);
    }

    private void cacheFillsFrom(StartElement startElement) throws XMLStreamException {
        this.cache.fills = new ExcelStyleDefinition.Fills(this.eventFactory, startElement);
        this.cache.fills.readWith(this.eventReader);
    }

    private void cacheBordersFrom(StartElement startElement) throws XMLStreamException {
        this.cache.borders = new ExcelStyleDefinition.Borders(new ExcelStyleDefinition.Default(this.eventFactory, startElement));
        this.cache.borders.readWith(this.eventReader);
    }

    private void cacheCellStyleFormatsFrom(StartElement startElement) throws XMLStreamException {
        this.cache.cellStyleFormats = new ExcelStyleDefinition.CellStyleFormats(new ExcelStyleDefinition.CellFormats(this.eventFactory, startElement));
        this.cache.cellStyleFormats.readWith(this.eventReader);
    }

    private void cacheCellFormatsFrom(StartElement startElement) throws XMLStreamException {
        this.cache.cellFormats = new ExcelStyleDefinition.CellFormats(this.eventFactory, startElement);
        this.cache.cellFormats.readWith(this.eventReader);
    }

    private void cacheCellStylesFrom(StartElement startElement) throws XMLStreamException {
        this.cache.cellStyles = new ExcelStyleDefinition.CellStyles(this.eventFactory, startElement);
        this.cache.cellStyles.readWith(this.eventReader);
    }

    private void cacheDifferentialFormatsFrom(StartElement startElement) throws XMLStreamException {
        this.cache.differentialFormats = new ExcelStyleDefinition.DifferentialFormats(this.conditionalParameters, this.eventFactory, startElement);
        this.cache.differentialFormats.readWith(this.eventReader);
    }

    private void cacheTableStylesFrom(StartElement startElement) throws XMLStreamException {
        this.cache.tableStyles = new ExcelStyleDefinition.TableStyles(new ExcelStyleDefinition.Default(this.eventFactory, startElement));
        this.cache.tableStyles.readWith(this.eventReader);
    }

    private void cacheColorsFrom(StartElement startElement) throws XMLStreamException {
        this.cache.colors = new ExcelStyleDefinition.Colors(new ExcelStyleDefinition.Default(this.eventFactory, startElement));
        this.cache.colors.readWith(this.eventReader);
    }

    private void cacheExtensionsFrom(StartElement startElement) throws XMLStreamException {
        this.cache.extensions = new ExcelStyleDefinition.Extensions(new ExcelStyleDefinition.Default(this.eventFactory, startElement));
        this.cache.extensions.readWith(this.eventReader);
    }

    @Override
    public EndElement endElement() throws XMLStreamException {
        if (!this.cache.extensionsAvailable()) {
            this.extensions();
        }
        if (this.cache.endElementAvailable()) {
            return this.cache.endElement;
        }
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!event.isEndElement() || !"styleSheet".equals(event.asEndElement().getName().getLocalPart())) continue;
            this.cache.endElement = event.asEndElement();
            return this.cache.endElement;
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("the end element is absent"));
    }

    EndDocument endDocument() throws XMLStreamException {
        if (!this.cache.endElementAvailable()) {
            this.endElement();
        }
        if (this.cache.endDocumentAvailable()) {
            return this.cache.endDocument;
        }
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!event.isEndDocument()) continue;
            this.cache.endDocument = (EndDocument)event;
            return this.cache.endDocument;
        }
        this.cache.endDocument = this.eventFactory.createEndDocument();
        return this.cache.endDocument;
    }

    private static final class Cache {
        private StartDocument startDocument;
        private StartElement startElement;
        private ExcelStyleDefinition.NumberFormats numberFormats;
        private ExcelStyleDefinition.Fonts fonts;
        private ExcelStyleDefinition.Fills fills;
        private ExcelStyleDefinition.Borders borders;
        private ExcelStyleDefinition.CellStyleFormats cellStyleFormats;
        private ExcelStyleDefinition.CellFormats cellFormats;
        private ExcelStyleDefinition.CellStyles cellStyles;
        private ExcelStyleDefinition.DifferentialFormats differentialFormats;
        private ExcelStyleDefinition.TableStyles tableStyles;
        private ExcelStyleDefinition.Colors colors;
        private ExcelStyleDefinition.Extensions extensions;
        private EndElement endElement;
        private EndDocument endDocument;

        Cache() {
        }

        boolean startDocumentAvailable() {
            return null != this.startDocument;
        }

        boolean startElementAvailable() {
            return null != this.startElement;
        }

        boolean numberFormatsAvailable() {
            return null != this.numberFormats;
        }

        boolean fontsAvailable() {
            return null != this.fonts;
        }

        boolean fillsAvailable() {
            return null != this.fills;
        }

        boolean bordersAvailable() {
            return null != this.borders;
        }

        boolean cellStyleFormatsAvailable() {
            return null != this.cellStyleFormats;
        }

        boolean cellFormatsAvailable() {
            return null != this.cellFormats;
        }

        boolean cellStylesAvailable() {
            return null != this.cellStyles;
        }

        boolean differentialFormatsAvailable() {
            return null != this.differentialFormats;
        }

        boolean tableStylesAvailable() {
            return null != this.tableStyles;
        }

        boolean colorsAvailable() {
            return null != this.colors;
        }

        boolean extensionsAvailable() {
            return null != this.extensions;
        }

        boolean endElementAvailable() {
            return null != this.endElement;
        }

        boolean endDocumentAvailable() {
            return null != this.endDocument;
        }
    }
}

