/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.idml.CodeTypes;
import net.sf.okapi.filters.idml.ContentCode;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.ReferentEventsAccumulation;
import net.sf.okapi.filters.idml.SpecialCharacter;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyleRanges;
import net.sf.okapi.filters.idml.StyledTextSkeleton;

class StyledTextElementsMapping {
    private static final String REFERENT_GROUP = "rg";
    private static final String CONTENT = "content";
    private static final String DASH = "-";
    private static final String TAG_OPENING = "<";
    private static final String TAG_CLOSING = ">";
    private static final String TAG_CLOSING_SINGLE = "/>";
    private static final String CONTENT_TAG_OPENING = "<content";
    private static final String CONTENT_TAG_CLOSING = "</content";
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final IdGenerator documentPartIdGenerator;
    private final String textUnitId;
    private final List<Event> referentEvents;
    private final Map<Integer, Object> codeMap;
    private final Deque<ContentCode> contentCodes;
    private StyleRanges baseStyleRanges;
    private IdGenerator referentIdGenerator;
    private int nextCodeId;

    StyledTextElementsMapping(Parameters parameters, XMLEventFactory eventFactory, IdGenerator documentPartIdGenerator, IdGenerator textUnitIdGenerator) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.documentPartIdGenerator = documentPartIdGenerator;
        this.textUnitId = textUnitIdGenerator.createId();
        this.referentEvents = new ArrayList<Event>();
        this.codeMap = new HashMap<Integer, Object>();
        this.contentCodes = new ArrayDeque<ContentCode>();
        this.nextCodeId = 1;
    }

    List<Event> eventsFor(List<StoryChildElement> styledTextElements) throws XMLStreamException {
        this.baseStyleRanges = this.baseStyleRanges(styledTextElements);
        TextFragment textFragment = new TextFragment();
        boolean translatable = this.assembleTextFragment(styledTextElements, textFragment, this.contentCodes.size());
        if (!translatable && 0 == this.referentEvents.size()) {
            return Collections.singletonList(this.createDocumentPartEvent(styledTextElements));
        }
        ArrayList<Event> events = new ArrayList<Event>(1 + this.referentEvents.size());
        events.add(this.createTextUnitEvent(styledTextElements, textFragment, this.textUnitId));
        events.addAll(this.referentEvents);
        return events;
    }

    private StyleRanges baseStyleRanges(List<StoryChildElement> storyChildElements) {
        return storyChildElements.stream().filter(e -> e instanceof StoryChildElement.StyledTextElement.Content).map(e -> ((StoryChildElement.StyledTextElement.Content)e).getStyleRanges()).min(Comparator.comparingInt(sd -> sd.amount())).orElseGet(() -> StyleRanges.defaultStyleRanges(this.eventFactory));
    }

    private boolean assembleTextFragment(List<StoryChildElement> textUnitElements, TextFragment textFragment, int inlineReferenceOpeningDepth) throws XMLStreamException {
        boolean translatable = false;
        for (StoryChildElement storyChildElement : textUnitElements) {
            if (storyChildElement instanceof StoryChildElement.StyledTextElement.Break) {
                if (!this.parameters.getExtractBreaksInline() && 0 >= inlineReferenceOpeningDepth) break;
                this.addIsolatedCode(textFragment, storyChildElement);
                continue;
            }
            if (storyChildElement instanceof StoryChildElement.StyledTextReferenceElement) {
                translatable |= this.addReferenceableContent(textFragment, (StoryChildElement.StyledTextReferenceElement)storyChildElement, this.textUnitId, inlineReferenceOpeningDepth);
                continue;
            }
            if (storyChildElement instanceof StoryChildElement.StyledTextElement.Content) {
                translatable |= this.addContent(textFragment, (StoryChildElement.StyledTextElement.Content)storyChildElement, inlineReferenceOpeningDepth);
                continue;
            }
            this.addIsolatedCode(textFragment, storyChildElement);
        }
        this.popContentCodesToDepth(textFragment, inlineReferenceOpeningDepth);
        return translatable;
    }

    private boolean addReferenceableContent(TextFragment textFragment, StoryChildElement.StyledTextReferenceElement styledTextReferenceElement, String parentId, int inlineReferenceOpeningDepth) throws XMLStreamException {
        if (styledTextReferenceElement instanceof StoryChildElement.StyledTextReferenceElement.HyperlinkTextSource) {
            return this.addHyperlinkTextSource(textFragment, styledTextReferenceElement, inlineReferenceOpeningDepth);
        }
        if (styledTextReferenceElement instanceof StoryChildElement.StyledTextReferenceElement.Note && !this.parameters.getExtractNotes()) {
            this.addIsolatedCode(textFragment, styledTextReferenceElement);
            return false;
        }
        this.referentIdGenerator = this.getReferentIdGenerator(parentId, REFERENT_GROUP);
        List<Event> events = new ReferentEventsAccumulation(this.parameters, this.eventFactory, styledTextReferenceElement, parentId, this.referentIdGenerator).asList();
        if (2 == events.size()) {
            this.addIsolatedCode(textFragment, styledTextReferenceElement);
            return false;
        }
        if (!events.get(0).isStartGroup()) {
            throw new IllegalStateException("Unexpected structure");
        }
        this.addIsolatedCode(textFragment, styledTextReferenceElement, events.get(0).getStartGroup().getId());
        this.referentEvents.addAll(events);
        return false;
    }

    private IdGenerator getReferentIdGenerator(String parentId, String prefix) {
        if (null != this.referentIdGenerator) {
            return this.referentIdGenerator;
        }
        return new IdGenerator(parentId, prefix);
    }

    private boolean addHyperlinkTextSource(TextFragment textFragment, StoryChildElement.StyledTextReferenceElement styledTextReferenceElement, int inlineReferenceOpeningDepth) throws XMLStreamException {
        StyleRanges styleRanges = styledTextReferenceElement.getStyleRanges();
        this.addClosingCodes(textFragment, styleRanges, inlineReferenceOpeningDepth);
        ContentCode contentCode = new ContentCode(this.nextCodeId++, styledTextReferenceElement.getStyleRanges(), styledTextReferenceElement);
        this.contentCodes.push(contentCode);
        this.addOpeningCode(textFragment, contentCode);
        boolean translatable = this.assembleTextFragment(styledTextReferenceElement.getStoryChildElements(), textFragment, this.contentCodes.size());
        this.addClosingCode(textFragment, this.contentCodes.pop());
        return translatable;
    }

    protected boolean addContent(TextFragment textFragment, StoryChildElement.StyledTextElement.Content content, int inlineReferenceOpeningDepth) {
        StyleRanges styleRanges = content.getStyleRanges();
        this.addClosingCodes(textFragment, styleRanges, inlineReferenceOpeningDepth);
        if (!(this.baseStyleRanges.equals(styleRanges) || this.contentCodes.size() != inlineReferenceOpeningDepth && this.contentCodes.peekFirst().getStyleRanges().equals(styleRanges))) {
            ContentCode contentCode = new ContentCode(this.nextCodeId++, styleRanges, null);
            this.contentCodes.push(contentCode);
            this.addOpeningCode(textFragment, contentCode);
        }
        this.addTranslatableContent(textFragment, content);
        return true;
    }

    private void addClosingCodes(TextFragment textFragment, StyleRanges styleRanges, int inlineReferenceOpeningDepth) {
        while (this.contentCodes.size() > inlineReferenceOpeningDepth && !this.contentCodes.peekFirst().getStyleRanges().isSubsetOf(styleRanges)) {
            this.addClosingCode(textFragment, this.contentCodes.pop());
        }
    }

    protected void addTranslatableContent(TextFragment textFragment, StoryChildElement.StyledTextElement.Content content) {
        for (XMLEvent event : content.innerEvents()) {
            if (event.isProcessingInstruction()) {
                this.addIsolatedCode(textFragment, new SpecialCharacter.Instruction(event));
                continue;
            }
            if (!event.isCharacters()) {
                throw new IllegalStateException("Unexpected structure");
            }
            this.isolateSpecialCharacters(textFragment, event.asCharacters().getData());
        }
    }

    private void isolateSpecialCharacters(TextFragment textFragment, String characters) {
        for (int i = 0; i < characters.length(); ++i) {
            char character = characters.charAt(i);
            SpecialCharacter.Type specialCharacterType = SpecialCharacter.Type.fromDefaultString(String.valueOf(character));
            if (this.parameters.getSkipDiscretionaryHyphens() && SpecialCharacter.Type.DISCRETIONARY_HYPHEN == specialCharacterType) continue;
            if (SpecialCharacter.Type.UNSUPPORTED != specialCharacterType) {
                SpecialCharacter.Default specialCharacter = new SpecialCharacter.Default(this.eventFactory.createCharacters(String.valueOf(character)));
                this.addIsolatedCode(textFragment, specialCharacter, null);
                continue;
            }
            textFragment.append(character);
        }
    }

    private void popContentCodesToDepth(TextFragment textFragment, int contentCodesDepth) {
        while (contentCodesDepth < this.contentCodes.size()) {
            this.addClosingCode(textFragment, this.contentCodes.pop());
        }
    }

    private void addOpeningCode(TextFragment textFragment, ContentCode contentCode) {
        Code code = new Code(TextFragment.TagType.OPENING, contentCode.getCodeType());
        code.setId(contentCode.getCodeId());
        code.setData("<content-" + code.getId() + TAG_CLOSING);
        textFragment.append(code);
        this.codeMap.put(contentCode.getCodeId(), null == contentCode.getStyledTextReferenceElement() ? contentCode.getStyleRanges() : contentCode.getStyledTextReferenceElement());
    }

    private void addClosingCode(TextFragment textFragment, ContentCode contentCode) {
        Code code = new Code(TextFragment.TagType.CLOSING, contentCode.getCodeType());
        code.setId(contentCode.getCodeId());
        code.setData("</content-" + code.getId() + TAG_CLOSING);
        textFragment.append(code);
    }

    private void addIsolatedCode(TextFragment textFragment, MarkupRange markupRange) {
        this.addIsolatedCode(textFragment, markupRange, null);
    }

    private void addIsolatedCode(TextFragment textFragment, MarkupRange markupRange, String referentId) {
        int codeId = this.nextCodeId++;
        String codeType = CodeTypes.createCodeType(markupRange);
        String codeData = this.getCodeData(referentId, codeId);
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, codeType, codeData);
        code.setId(codeId);
        if (null != referentId) {
            code.setReferenceFlag(true);
        }
        textFragment.append(code);
        this.codeMap.put(codeId, markupRange);
    }

    private String getCodeData(String referentId, int codeId) {
        if (null == referentId) {
            return "<content-" + codeId + TAG_CLOSING_SINGLE;
        }
        return "<content-" + referentId + DASH + codeId + TAG_CLOSING_SINGLE;
    }

    private Event createTextUnitEvent(List<StoryChildElement> textUnitElements, TextFragment textFragment, String id) {
        TextUnit textUnit = new TextUnit(id);
        textUnit.setPreserveWhitespaces(true);
        textUnit.setSource(new TextContainer(textFragment));
        StyledTextSkeleton skeleton = new StyledTextSkeleton(textUnitElements, this.baseStyleRanges, this.codeMap);
        skeleton.setParent(textUnit);
        textUnit.setSkeleton(skeleton);
        return new Event(EventType.TEXT_UNIT, textUnit);
    }

    private Event createDocumentPartEvent(List<StoryChildElement> textUnitElements) {
        DocumentPart documentPart = new DocumentPart(this.documentPartIdGenerator.createId(), false);
        documentPart.setSkeleton(new StyledTextSkeleton(textUnitElements, this.baseStyleRanges, Collections.emptyMap()));
        return new Event(EventType.DOCUMENT_PART, documentPart);
    }
}

